/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
 * RecipeProcessElementText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessElementTextField
 * RecipeProcessElementTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessElementTextLink
 * RecipeProcessElementTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_PROCESS_ELEMENT_UUID
 * RECIPE_PROCESS_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_PROCESS_UUID
 * RECIPE_PROCESS_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_PROCESS_ELEMENT_DESC
 * RECIPE_PROCESS_ELEMENT_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_LAST_CHANGE_DATE_TIME
 * RECIPE_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_UUID
 * RECIPE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE
 * RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_PROCESS_STAGE_POS_NMBR
 * RECIPE_PROCESS_STAGE_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_PROCESS_OPERATION_POS_NMBR
 * RECIPE_PROCESS_OPERATION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#RECIPE_PROCESS_ACTION_POS_NMBR
 * RECIPE_PROCESS_ACTION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText#TO_RECIPE_PROCESS_ELEMENT
 * TO_RECIPE_PROCESS_ELEMENT}</li>
 * </ul>
 *
 */
public interface RecipeProcessElementTextSelectable extends EntitySelectable<RecipeProcessElementText>
{

}
