/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam
 * RecipeProcessParam}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessParamField
 * RecipeProcessParamField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessParamLink
 * RecipeProcessParamLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_UUID
 * RECIPE_PROCESS_PARAM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM
 * RECIPE_PROCESS_PARAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_UNIT
 * RECIPE_PROCESS_PARAM_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_UNIT_IS_FXD
 * RECIPE_PROCESS_PARAM_UNIT_IS_FXD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_TGT_VAL
 * RECIPE_PROCESS_PARAM_TGT_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_TGT_VAL_IS_FXD
 * RECIPE_PROCESS_PARAM_TGT_VAL_IS_FXD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_MIN_VAL
 * RECIPE_PROCESS_PARAM_MIN_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_MIN_VAL_IS_FXD
 * RECIPE_PROCESS_PARAM_MIN_VAL_IS_FXD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_MAX_VAL
 * RECIPE_PROCESS_PARAM_MAX_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_MAX_VAL_IS_FXD
 * RECIPE_PROCESS_PARAM_MAX_VAL_IS_FXD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_DEC_PLACES
 * RECIPE_PROCESS_PARAM_DEC_PLACES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_GROUP
 * RECIPE_PROCESS_PARAM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_CLASS
 * RECIPE_PROCESS_PARAM_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_IS_OBSOLETE
 * RECIPE_PROCESS_PARAM_IS_OBSOLETE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#RECIPE_PROCESS_PARAM_IS_DELETED
 * RECIPE_PROCESS_PARAM_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam#TO_RECIPE_PROCESS_PARAM_DESC
 * TO_RECIPE_PROCESS_PARAM_DESC}</li>
 * </ul>
 *
 */
public interface RecipeProcessParamSelectable extends EntitySelectable<RecipeProcessParam>
{

}
