/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
 * RecipeProcessParamValueTxt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessParamValueTxtField
 * RecipeProcessParamValueTxtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessParamValueTxtLink
 * RecipeProcessParamValueTxtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_PARAM_VAL_UUID
 * RECIPE_PROCESS_PARAM_VAL_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_UUID
 * RECIPE_PROCESS_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_PARAM_VALUE_DESC
 * RECIPE_PROCESS_PARAM_VALUE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_LAST_CHANGE_DATE_TIME
 * RECIPE_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_UUID
 * RECIPE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE
 * RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_EQUIP_RQMT_POS_NMBR
 * RECIPE_PROCESS_EQUIP_RQMT_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_STAGE_POS_NMBR
 * RECIPE_PROCESS_STAGE_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_OPERATION_POS_NMBR
 * RECIPE_PROCESS_OPERATION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_ACTION_POS_NMBR
 * RECIPE_PROCESS_ACTION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#RECIPE_PROCESS_PARAM_SQNC_NMBR
 * RECIPE_PROCESS_PARAM_SQNC_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt#TO_RECIPE_PROCESS_PARAM_VALUE
 * TO_RECIPE_PROCESS_PARAM_VALUE}</li>
 * </ul>
 *
 */
public interface RecipeProcessParamValueTxtSelectable extends EntitySelectable<RecipeProcessParamValueTxt>
{

}
