/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>ChangeStatusExportParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ChangeStatusExportParameters extends VdmComplex<ChangeStatusExportParameters>
{

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>RFQLifecycleStatus</b>
     * </p>
     *
     * @param rFQLifecycleStatus
     *
     * @return RFQ Lifecycle Status
     */
    @SerializedName( "RFQLifecycleStatus" )
    @JsonProperty( "RFQLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "RFQLifecycleStatus" )
    private String rFQLifecycleStatus;

    @Nonnull
    @Override
    public Class<ChangeStatusExportParameters> getType()
    {
        return ChangeStatusExportParameters.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RFQLifecycleStatus", getRFQLifecycleStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RFQLifecycleStatus") ) {
                final Object value = values.remove("RFQLifecycleStatus");
                if( (value == null) || (!value.equals(getRFQLifecycleStatus())) ) {
                    setRFQLifecycleStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>RFQLifecycleStatus</b>
     * </p>
     *
     * @param rFQLifecycleStatus
     *            RFQ Lifecycle Status
     */
    public void setRFQLifecycleStatus( @Nullable final String rFQLifecycleStatus )
    {
        rememberChangedField("RFQLifecycleStatus", this.rFQLifecycleStatus);
        this.rFQLifecycleStatus = rFQLifecycleStatus;
    }

}
