/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.field.RequestForQuotationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.link.RequestForQuotationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.selectable.RequestForQuotationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Request for Quotation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RequestForQuotationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RequestForQuotation extends VdmEntity<RequestForQuotation>
{

    /**
     * Selector for all available fields of RequestForQuotation.
     *
     */
    public final static RequestForQuotationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @return Request for Quotation
     */
    @Key
    @SerializedName( "RequestForQuotation" )
    @JsonProperty( "RequestForQuotation" )
    @Nullable
    @ODataField( odataName = "RequestForQuotation" )
    private String requestForQuotation;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotation</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> REQUEST_FOR_QUOTATION =
        new RequestForQuotationField<String>("RequestForQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> COMPANY_CODE =
        new RequestForQuotationField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> PURCHASING_DOCUMENT_CATEGORY =
        new RequestForQuotationField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @return RFQ Document Type
     */
    @SerializedName( "PurchasingDocumentType" )
    @JsonProperty( "PurchasingDocumentType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentType" )
    private String purchasingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentType</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> PURCHASING_DOCUMENT_TYPE =
        new RequestForQuotationField<String>("PurchasingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User of person who created a purchasing document
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> CREATED_BY_USER =
        new RequestForQuotationField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date of Purchasing Document
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<LocalDateTime> CREATION_DATE =
        new RequestForQuotationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Change Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new RequestForQuotationField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> LANGUAGE = new RequestForQuotationField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> PURCHASING_ORGANIZATION =
        new RequestForQuotationField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> PURCHASING_GROUP =
        new RequestForQuotationField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> DOCUMENT_CURRENCY =
        new RequestForQuotationField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> INCOTERMS_CLASSIFICATION =
        new RequestForQuotationField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> INCOTERMS_TRANSFER_LOCATION =
        new RequestForQuotationField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> INCOTERMS_VERSION =
        new RequestForQuotationField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> INCOTERMS_LOCATION1 =
        new RequestForQuotationField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> INCOTERMS_LOCATION2 =
        new RequestForQuotationField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> PAYMENT_TERMS =
        new RequestForQuotationField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new RequestForQuotationField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new RequestForQuotationField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash discount percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new RequestForQuotationField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash discount percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new RequestForQuotationField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<BigDecimal> NET_PAYMENT_DAYS =
        new RequestForQuotationField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RFQPublishingDate</b>
     * </p>
     *
     * @return RFQ Publishing Date
     */
    @SerializedName( "RFQPublishingDate" )
    @JsonProperty( "RFQPublishingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RFQPublishingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime rFQPublishingDate;
    /**
     * Use with available fluent helpers to apply the <b>RFQPublishingDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<LocalDateTime> RFQ_PUBLISHING_DATE =
        new RequestForQuotationField<LocalDateTime>("RFQPublishingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationLatestSubmissionDate</b>
     * </p>
     *
     * @return Deadline for Submission of Bid/Quotation
     */
    @SerializedName( "QuotationLatestSubmissionDate" )
    @JsonProperty( "QuotationLatestSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationLatestSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationLatestSubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationLatestSubmissionDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<LocalDateTime> QUOTATION_LATEST_SUBMISSION_DATE =
        new RequestForQuotationField<LocalDateTime>("QuotationLatestSubmissionDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BindingPeriodValidityEndDate</b>
     * </p>
     *
     * @return Binding Period for Quotation
     */
    @SerializedName( "BindingPeriodValidityEndDate" )
    @JsonProperty( "BindingPeriodValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BindingPeriodValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bindingPeriodValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BindingPeriodValidityEndDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<LocalDateTime> BINDING_PERIOD_VALIDITY_END_DATE =
        new RequestForQuotationField<LocalDateTime>("BindingPeriodValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetAmount</b>
     * </p>
     *
     * @return Target Value for Header Area per Distribution
     */
    @SerializedName( "TargetAmount" )
    @JsonProperty( "TargetAmount" )
    @Nullable
    @ODataField( odataName = "TargetAmount" )
    private BigDecimal targetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TargetAmount</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<BigDecimal> TARGET_AMOUNT =
        new RequestForQuotationField<BigDecimal>("TargetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @return Our Reference
     */
    @SerializedName( "CorrespncInternalReference" )
    @JsonProperty( "CorrespncInternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncInternalReference" )
    private String correspncInternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncInternalReference</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> CORRESPNC_INTERNAL_REFERENCE =
        new RequestForQuotationField<String>("CorrespncInternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RFQLifecycleStatus</b>
     * </p>
     *
     * @return RFQ Lifecycle Status
     */
    @SerializedName( "RFQLifecycleStatus" )
    @JsonProperty( "RFQLifecycleStatus" )
    @Nullable
    @ODataField( odataName = "RFQLifecycleStatus" )
    private String rFQLifecycleStatus;
    /**
     * Use with available fluent helpers to apply the <b>RFQLifecycleStatus</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> RFQ_LIFECYCLE_STATUS =
        new RequestForQuotationField<String>("RFQLifecycleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotationName</b>
     * </p>
     *
     * @return Short description or the title of the RFQ
     */
    @SerializedName( "RequestForQuotationName" )
    @JsonProperty( "RequestForQuotationName" )
    @Nullable
    @ODataField( odataName = "RequestForQuotationName" )
    private String requestForQuotationName;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotationName</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> REQUEST_FOR_QUOTATION_NAME =
        new RequestForQuotationField<String>("RequestForQuotationName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationEarliestSubmsnDate</b>
     * </p>
     *
     * @return The date as of which Quotations can be submitted
     */
    @SerializedName( "QuotationEarliestSubmsnDate" )
    @JsonProperty( "QuotationEarliestSubmsnDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationEarliestSubmsnDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationEarliestSubmsnDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationEarliestSubmsnDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<LocalDateTime> QUOTATION_EARLIEST_SUBMSN_DATE =
        new RequestForQuotationField<LocalDateTime>("QuotationEarliestSubmsnDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestRegistrationDate</b>
     * </p>
     *
     * @return Closing Date for Applications
     */
    @SerializedName( "LatestRegistrationDate" )
    @JsonProperty( "LatestRegistrationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestRegistrationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestRegistrationDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestRegistrationDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<LocalDateTime> LATEST_REGISTRATION_DATE =
        new RequestForQuotationField<LocalDateTime>("LatestRegistrationDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentCategory</b>
     * </p>
     *
     * @return Follow-On Purchasing Document Category
     */
    @SerializedName( "FollowOnDocumentCategory" )
    @JsonProperty( "FollowOnDocumentCategory" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentCategory" )
    private String followOnDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>FollowOnDocumentCategory</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> FOLLOW_ON_DOCUMENT_CATEGORY =
        new RequestForQuotationField<String>("FollowOnDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @return Follow-On Purchasing Document Type
     */
    @SerializedName( "FollowOnDocumentType" )
    @JsonProperty( "FollowOnDocumentType" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentType" )
    private String followOnDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>FollowOnDocumentType</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> FOLLOW_ON_DOCUMENT_TYPE =
        new RequestForQuotationField<String>("FollowOnDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static RequestForQuotationField<String> IS_END_OF_PURPOSE_BLOCKED =
        new RequestForQuotationField<String>("IsEndOfPurposeBlocked");
    /**
     * Navigation property <b>to_RequestForQuotationBidder</b> for <b>RequestForQuotation</b> to multiple
     * <b>RequestForQuotationBidder</b>.
     *
     */
    @SerializedName( "to_RequestForQuotationBidder" )
    @JsonProperty( "to_RequestForQuotationBidder" )
    @ODataField( odataName = "to_RequestForQuotationBidder" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RequestForQuotationBidder> toRequestForQuotationBidder;
    /**
     * Navigation property <b>to_RequestForQuotationItem</b> for <b>RequestForQuotation</b> to multiple
     * <b>RequestForQuotationItem</b>.
     *
     */
    @SerializedName( "to_RequestForQuotationItem" )
    @JsonProperty( "to_RequestForQuotationItem" )
    @ODataField( odataName = "to_RequestForQuotationItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RequestForQuotationItem> toRequestForQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>to_RequestForQuotationBidder</b> navigation property to query
     * operations.
     *
     */
    public final static RequestForQuotationLink<RequestForQuotationBidder> TO_REQUEST_FOR_QUOTATION_BIDDER =
        new RequestForQuotationLink<RequestForQuotationBidder>("to_RequestForQuotationBidder");
    /**
     * Use with available fluent helpers to apply the <b>to_RequestForQuotationItem</b> navigation property to query
     * operations.
     *
     */
    public final static RequestForQuotationLink<RequestForQuotationItem> TO_REQUEST_FOR_QUOTATION_ITEM =
        new RequestForQuotationLink<RequestForQuotationItem>("to_RequestForQuotationItem");

    @Nonnull
    @Override
    public Class<RequestForQuotation> getType()
    {
        return RequestForQuotation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *            Request for Quotation
     */
    public void setRequestForQuotation( @Nullable final String requestForQuotation )
    {
        rememberChangedField("RequestForQuotation", this.requestForQuotation);
        this.requestForQuotation = requestForQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *            RFQ Document Type
     */
    public void setPurchasingDocumentType( @Nullable final String purchasingDocumentType )
    {
        rememberChangedField("PurchasingDocumentType", this.purchasingDocumentType);
        this.purchasingDocumentType = purchasingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User of person who created a purchasing document
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date of Purchasing Document
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Change Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash discount percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash discount percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RFQPublishingDate</b>
     * </p>
     *
     * @param rFQPublishingDate
     *            RFQ Publishing Date
     */
    public void setRFQPublishingDate( @Nullable final LocalDateTime rFQPublishingDate )
    {
        rememberChangedField("RFQPublishingDate", this.rFQPublishingDate);
        this.rFQPublishingDate = rFQPublishingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationLatestSubmissionDate</b>
     * </p>
     *
     * @param quotationLatestSubmissionDate
     *            Deadline for Submission of Bid/Quotation
     */
    public void setQuotationLatestSubmissionDate( @Nullable final LocalDateTime quotationLatestSubmissionDate )
    {
        rememberChangedField("QuotationLatestSubmissionDate", this.quotationLatestSubmissionDate);
        this.quotationLatestSubmissionDate = quotationLatestSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BindingPeriodValidityEndDate</b>
     * </p>
     *
     * @param bindingPeriodValidityEndDate
     *            Binding Period for Quotation
     */
    public void setBindingPeriodValidityEndDate( @Nullable final LocalDateTime bindingPeriodValidityEndDate )
    {
        rememberChangedField("BindingPeriodValidityEndDate", this.bindingPeriodValidityEndDate);
        this.bindingPeriodValidityEndDate = bindingPeriodValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetAmount</b>
     * </p>
     *
     * @param targetAmount
     *            Target Value for Header Area per Distribution
     */
    public void setTargetAmount( @Nullable final BigDecimal targetAmount )
    {
        rememberChangedField("TargetAmount", this.targetAmount);
        this.targetAmount = targetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @param correspncInternalReference
     *            Our Reference
     */
    public void setCorrespncInternalReference( @Nullable final String correspncInternalReference )
    {
        rememberChangedField("CorrespncInternalReference", this.correspncInternalReference);
        this.correspncInternalReference = correspncInternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RFQLifecycleStatus</b>
     * </p>
     *
     * @param rFQLifecycleStatus
     *            RFQ Lifecycle Status
     */
    public void setRFQLifecycleStatus( @Nullable final String rFQLifecycleStatus )
    {
        rememberChangedField("RFQLifecycleStatus", this.rFQLifecycleStatus);
        this.rFQLifecycleStatus = rFQLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotationName</b>
     * </p>
     *
     * @param requestForQuotationName
     *            Short description or the title of the RFQ
     */
    public void setRequestForQuotationName( @Nullable final String requestForQuotationName )
    {
        rememberChangedField("RequestForQuotationName", this.requestForQuotationName);
        this.requestForQuotationName = requestForQuotationName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationEarliestSubmsnDate</b>
     * </p>
     *
     * @param quotationEarliestSubmsnDate
     *            The date as of which Quotations can be submitted
     */
    public void setQuotationEarliestSubmsnDate( @Nullable final LocalDateTime quotationEarliestSubmsnDate )
    {
        rememberChangedField("QuotationEarliestSubmsnDate", this.quotationEarliestSubmsnDate);
        this.quotationEarliestSubmsnDate = quotationEarliestSubmsnDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestRegistrationDate</b>
     * </p>
     *
     * @param latestRegistrationDate
     *            Closing Date for Applications
     */
    public void setLatestRegistrationDate( @Nullable final LocalDateTime latestRegistrationDate )
    {
        rememberChangedField("LatestRegistrationDate", this.latestRegistrationDate);
        this.latestRegistrationDate = latestRegistrationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentCategory</b>
     * </p>
     *
     * @param followOnDocumentCategory
     *            Follow-On Purchasing Document Category
     */
    public void setFollowOnDocumentCategory( @Nullable final String followOnDocumentCategory )
    {
        rememberChangedField("FollowOnDocumentCategory", this.followOnDocumentCategory);
        this.followOnDocumentCategory = followOnDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @param followOnDocumentType
     *            Follow-On Purchasing Document Type
     */
    public void setFollowOnDocumentType( @Nullable final String followOnDocumentType )
    {
        rememberChangedField("FollowOnDocumentType", this.followOnDocumentType);
        this.followOnDocumentType = followOnDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RequestForQuotation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RequestForQuotation", getRequestForQuotation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RequestForQuotation", getRequestForQuotation());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentType", getPurchasingDocumentType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Language", getLanguage());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("RFQPublishingDate", getRFQPublishingDate());
        values.put("QuotationLatestSubmissionDate", getQuotationLatestSubmissionDate());
        values.put("BindingPeriodValidityEndDate", getBindingPeriodValidityEndDate());
        values.put("TargetAmount", getTargetAmount());
        values.put("CorrespncInternalReference", getCorrespncInternalReference());
        values.put("RFQLifecycleStatus", getRFQLifecycleStatus());
        values.put("RequestForQuotationName", getRequestForQuotationName());
        values.put("QuotationEarliestSubmsnDate", getQuotationEarliestSubmsnDate());
        values.put("LatestRegistrationDate", getLatestRegistrationDate());
        values.put("FollowOnDocumentCategory", getFollowOnDocumentCategory());
        values.put("FollowOnDocumentType", getFollowOnDocumentType());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RequestForQuotation") ) {
                final Object value = values.remove("RequestForQuotation");
                if( (value == null) || (!value.equals(getRequestForQuotation())) ) {
                    setRequestForQuotation(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentType") ) {
                final Object value = values.remove("PurchasingDocumentType");
                if( (value == null) || (!value.equals(getPurchasingDocumentType())) ) {
                    setPurchasingDocumentType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("RFQPublishingDate") ) {
                final Object value = values.remove("RFQPublishingDate");
                if( (value == null) || (!value.equals(getRFQPublishingDate())) ) {
                    setRFQPublishingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QuotationLatestSubmissionDate") ) {
                final Object value = values.remove("QuotationLatestSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationLatestSubmissionDate())) ) {
                    setQuotationLatestSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BindingPeriodValidityEndDate") ) {
                final Object value = values.remove("BindingPeriodValidityEndDate");
                if( (value == null) || (!value.equals(getBindingPeriodValidityEndDate())) ) {
                    setBindingPeriodValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TargetAmount") ) {
                final Object value = values.remove("TargetAmount");
                if( (value == null) || (!value.equals(getTargetAmount())) ) {
                    setTargetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CorrespncInternalReference") ) {
                final Object value = values.remove("CorrespncInternalReference");
                if( (value == null) || (!value.equals(getCorrespncInternalReference())) ) {
                    setCorrespncInternalReference(((String) value));
                }
            }
            if( values.containsKey("RFQLifecycleStatus") ) {
                final Object value = values.remove("RFQLifecycleStatus");
                if( (value == null) || (!value.equals(getRFQLifecycleStatus())) ) {
                    setRFQLifecycleStatus(((String) value));
                }
            }
            if( values.containsKey("RequestForQuotationName") ) {
                final Object value = values.remove("RequestForQuotationName");
                if( (value == null) || (!value.equals(getRequestForQuotationName())) ) {
                    setRequestForQuotationName(((String) value));
                }
            }
            if( values.containsKey("QuotationEarliestSubmsnDate") ) {
                final Object value = values.remove("QuotationEarliestSubmsnDate");
                if( (value == null) || (!value.equals(getQuotationEarliestSubmsnDate())) ) {
                    setQuotationEarliestSubmsnDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestRegistrationDate") ) {
                final Object value = values.remove("LatestRegistrationDate");
                if( (value == null) || (!value.equals(getLatestRegistrationDate())) ) {
                    setLatestRegistrationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FollowOnDocumentCategory") ) {
                final Object value = values.remove("FollowOnDocumentCategory");
                if( (value == null) || (!value.equals(getFollowOnDocumentCategory())) ) {
                    setFollowOnDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentType") ) {
                final Object value = values.remove("FollowOnDocumentType");
                if( (value == null) || (!value.equals(getFollowOnDocumentType())) ) {
                    setFollowOnDocumentType(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RequestForQuotationBidder") ) {
                final Object value = (values).remove("to_RequestForQuotationBidder");
                if( value instanceof Iterable ) {
                    if( toRequestForQuotationBidder == null ) {
                        toRequestForQuotationBidder = Lists.newArrayList();
                    } else {
                        toRequestForQuotationBidder = Lists.newArrayList(toRequestForQuotationBidder);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RequestForQuotationBidder entity;
                        if( toRequestForQuotationBidder.size() > i ) {
                            entity = toRequestForQuotationBidder.get(i);
                        } else {
                            entity = new RequestForQuotationBidder();
                            toRequestForQuotationBidder.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RequestForQuotationItem") ) {
                final Object value = (values).remove("to_RequestForQuotationItem");
                if( value instanceof Iterable ) {
                    if( toRequestForQuotationItem == null ) {
                        toRequestForQuotationItem = Lists.newArrayList();
                    } else {
                        toRequestForQuotationItem = Lists.newArrayList(toRequestForQuotationItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RequestForQuotationItem entity;
                        if( toRequestForQuotationItem.size() > i ) {
                            entity = toRequestForQuotationItem.get(i);
                        } else {
                            entity = new RequestForQuotationItem();
                            toRequestForQuotationItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RequestForQuotationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RequestForQuotationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RequestForQuotationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RequestForQuotationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRequestForQuotationBidder != null ) {
            (values).put("to_RequestForQuotationBidder", toRequestForQuotationBidder);
        }
        if( toRequestForQuotationItem != null ) {
            (values).put("to_RequestForQuotationItem", toRequestForQuotationItem);
        }
        return values;
    }

    /**
     * Fetches the <b>RequestForQuotationBidder</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RequestForQuotationBidder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RequestForQuotationBidder</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RequestForQuotationBidder> fetchRequestForQuotationBidder()
    {
        return fetchFieldAsList("to_RequestForQuotationBidder", RequestForQuotationBidder.class);
    }

    /**
     * Retrieval of associated <b>RequestForQuotationBidder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RequestForQuotationBidder</b>.
     * <p>
     * If the navigation property <b>to_RequestForQuotationBidder</b> of a queried <b>RequestForQuotation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RequestForQuotationBidder</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RequestForQuotationBidder> getRequestForQuotationBidderOrFetch()
    {
        if( toRequestForQuotationBidder == null ) {
            toRequestForQuotationBidder = fetchRequestForQuotationBidder();
        }
        return toRequestForQuotationBidder;
    }

    /**
     * Retrieval of associated <b>RequestForQuotationBidder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RequestForQuotationBidder</b>.
     * <p>
     * If the navigation property for an entity <b>RequestForQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RequestForQuotationBidder</b> is already loaded, the
     *         result will contain the <b>RequestForQuotationBidder</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RequestForQuotationBidder>> getRequestForQuotationBidderIfPresent()
    {
        return Option.of(toRequestForQuotationBidder);
    }

    /**
     * Overwrites the list of associated <b>RequestForQuotationBidder</b> entities for the loaded navigation property
     * <b>to_RequestForQuotationBidder</b>.
     * <p>
     * If the navigation property <b>to_RequestForQuotationBidder</b> of a queried <b>RequestForQuotation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RequestForQuotationBidder</b> entities.
     */
    public void setRequestForQuotationBidder( @Nonnull final List<RequestForQuotationBidder> value )
    {
        if( toRequestForQuotationBidder == null ) {
            toRequestForQuotationBidder = Lists.newArrayList();
        }
        toRequestForQuotationBidder.clear();
        toRequestForQuotationBidder.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RequestForQuotationBidder</b> entities. This corresponds to the OData
     * navigation property <b>to_RequestForQuotationBidder</b>.
     * <p>
     * If the navigation property <b>to_RequestForQuotationBidder</b> of a queried <b>RequestForQuotation</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RequestForQuotationBidder</b> entities.
     */
    public void addRequestForQuotationBidder( RequestForQuotationBidder... entity )
    {
        if( toRequestForQuotationBidder == null ) {
            toRequestForQuotationBidder = Lists.newArrayList();
        }
        toRequestForQuotationBidder.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RequestForQuotationItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RequestForQuotationItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RequestForQuotationItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RequestForQuotationItem> fetchRequestForQuotationItem()
    {
        return fetchFieldAsList("to_RequestForQuotationItem", RequestForQuotationItem.class);
    }

    /**
     * Retrieval of associated <b>RequestForQuotationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RequestForQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_RequestForQuotationItem</b> of a queried <b>RequestForQuotation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RequestForQuotationItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RequestForQuotationItem> getRequestForQuotationItemOrFetch()
    {
        if( toRequestForQuotationItem == null ) {
            toRequestForQuotationItem = fetchRequestForQuotationItem();
        }
        return toRequestForQuotationItem;
    }

    /**
     * Retrieval of associated <b>RequestForQuotationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RequestForQuotationItem</b>.
     * <p>
     * If the navigation property for an entity <b>RequestForQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RequestForQuotationItem</b> is already loaded, the
     *         result will contain the <b>RequestForQuotationItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RequestForQuotationItem>> getRequestForQuotationItemIfPresent()
    {
        return Option.of(toRequestForQuotationItem);
    }

    /**
     * Overwrites the list of associated <b>RequestForQuotationItem</b> entities for the loaded navigation property
     * <b>to_RequestForQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_RequestForQuotationItem</b> of a queried <b>RequestForQuotation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RequestForQuotationItem</b> entities.
     */
    public void setRequestForQuotationItem( @Nonnull final List<RequestForQuotationItem> value )
    {
        if( toRequestForQuotationItem == null ) {
            toRequestForQuotationItem = Lists.newArrayList();
        }
        toRequestForQuotationItem.clear();
        toRequestForQuotationItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RequestForQuotationItem</b> entities. This corresponds to the OData
     * navigation property <b>to_RequestForQuotationItem</b>.
     * <p>
     * If the navigation property <b>to_RequestForQuotationItem</b> of a queried <b>RequestForQuotation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RequestForQuotationItem</b> entities.
     */
    public void addRequestForQuotationItem( RequestForQuotationItem... entity )
    {
        if( toRequestForQuotationItem == null ) {
            toRequestForQuotationItem = Lists.newArrayList();
        }
        toRequestForQuotationItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RequestForQuotation instances.
     *
     */
    public final static class RequestForQuotationBuilder
    {

        private List<RequestForQuotationBidder> toRequestForQuotationBidder = Lists.newArrayList();
        private List<RequestForQuotationItem> toRequestForQuotationItem = Lists.newArrayList();

        private RequestForQuotation.RequestForQuotationBuilder toRequestForQuotationBidder(
            final List<RequestForQuotationBidder> value )
        {
            toRequestForQuotationBidder.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RequestForQuotationBidder</b> for <b>RequestForQuotation</b> to multiple
         * <b>RequestForQuotationBidder</b>.
         *
         * @param value
         *            The RequestForQuotationBidders to build this RequestForQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RequestForQuotation.RequestForQuotationBuilder requestForQuotationBidder(
            RequestForQuotationBidder... value )
        {
            return toRequestForQuotationBidder(Lists.newArrayList(value));
        }

        private RequestForQuotation.RequestForQuotationBuilder toRequestForQuotationItem(
            final List<RequestForQuotationItem> value )
        {
            toRequestForQuotationItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RequestForQuotationItem</b> for <b>RequestForQuotation</b> to multiple
         * <b>RequestForQuotationItem</b>.
         *
         * @param value
         *            The RequestForQuotationItems to build this RequestForQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RequestForQuotation.RequestForQuotationBuilder requestForQuotationItem(
            RequestForQuotationItem... value )
        {
            return toRequestForQuotationItem(Lists.newArrayList(value));
        }

    }

}
