/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.field.RequestForQuotationBidderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.selectable.RequestForQuotationBidderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Bidder
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RequestForQuotationBidderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RequestForQuotationBidder extends VdmEntity<RequestForQuotationBidder>
{

    /**
     * Selector for all available fields of RequestForQuotationBidder.
     *
     */
    public final static RequestForQuotationBidderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "RequestForQuotation" )
    @JsonProperty( "RequestForQuotation" )
    @Nullable
    @ODataField( odataName = "RequestForQuotation" )
    private String requestForQuotation;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotation</b> field to query operations.
     *
     */
    public final static RequestForQuotationBidderField<String> REQUEST_FOR_QUOTATION =
        new RequestForQuotationBidderField<String>("RequestForQuotation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCounter</b>
     * </p>
     *
     * @return Partner counter
     */
    @Key
    @SerializedName( "PartnerCounter" )
    @JsonProperty( "PartnerCounter" )
    @Nullable
    @ODataField( odataName = "PartnerCounter" )
    private String partnerCounter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCounter</b> field to query operations.
     *
     */
    public final static RequestForQuotationBidderField<String> PARTNER_COUNTER =
        new RequestForQuotationBidderField<String>("PartnerCounter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static RequestForQuotationBidderField<String> PARTNER_FUNCTION =
        new RequestForQuotationBidderField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static RequestForQuotationBidderField<String> SUPPLIER =
        new RequestForQuotationBidderField<String>("Supplier");

    @Nonnull
    @Override
    public Class<RequestForQuotationBidder> getType()
    {
        return RequestForQuotationBidder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *            Purchasing Document Number
     */
    public void setRequestForQuotation( @Nullable final String requestForQuotation )
    {
        rememberChangedField("RequestForQuotation", this.requestForQuotation);
        this.requestForQuotation = requestForQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCounter</b>
     * </p>
     *
     * @param partnerCounter
     *            Partner counter
     */
    public void setPartnerCounter( @Nullable final String partnerCounter )
    {
        rememberChangedField("PartnerCounter", this.partnerCounter);
        this.partnerCounter = partnerCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RequestForQuotationBidder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RequestForQuotation", getRequestForQuotation());
        result.put("PartnerCounter", getPartnerCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RequestForQuotation", getRequestForQuotation());
        values.put("PartnerCounter", getPartnerCounter());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Supplier", getSupplier());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RequestForQuotation") ) {
                final Object value = values.remove("RequestForQuotation");
                if( (value == null) || (!value.equals(getRequestForQuotation())) ) {
                    setRequestForQuotation(((String) value));
                }
            }
            if( values.containsKey("PartnerCounter") ) {
                final Object value = values.remove("PartnerCounter");
                if( (value == null) || (!value.equals(getPartnerCounter())) ) {
                    setPartnerCounter(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RequestForQuotationBidderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RequestForQuotationBidderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RequestForQuotationBidderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RequestForQuotationBidderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService.DEFAULT_SERVICE_PATH);
    }

}
