/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.field.RequestForQuotationItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.selectable.RequestForQuotationItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RequestForQuotationItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RequestForQuotationItem extends VdmEntity<RequestForQuotationItem>
{

    /**
     * Selector for all available fields of RequestForQuotationItem.
     *
     */
    public final static RequestForQuotationItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotationItem</b>
     * </p>
     *
     * @return Item Number of Request For Quotation
     */
    @Key
    @SerializedName( "RequestForQuotationItem" )
    @JsonProperty( "RequestForQuotationItem" )
    @Nullable
    @ODataField( odataName = "RequestForQuotationItem" )
    private String requestForQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotationItem</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> REQUEST_FOR_QUOTATION_ITEM =
        new RequestForQuotationItemField<String>("RequestForQuotationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "RequestForQuotation" )
    @JsonProperty( "RequestForQuotation" )
    @Nullable
    @ODataField( odataName = "RequestForQuotation" )
    private String requestForQuotation;
    /**
     * Use with available fluent helpers to apply the <b>RequestForQuotation</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> REQUEST_FOR_QUOTATION =
        new RequestForQuotationItemField<String>("RequestForQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> PURCHASING_DOCUMENT_CATEGORY =
        new RequestForQuotationItemField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "PurchasingDocumentItemText" )
    @JsonProperty( "PurchasingDocumentItemText" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemText" )
    private String purchasingDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemText</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> PURCHASING_DOCUMENT_ITEM_TEXT =
        new RequestForQuotationItemField<String>("PurchasingDocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> MATERIAL =
        new RequestForQuotationItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @return Manufacturer Material
     */
    @SerializedName( "ManufacturerMaterial" )
    @JsonProperty( "ManufacturerMaterial" )
    @Nullable
    @ODataField( odataName = "ManufacturerMaterial" )
    private String manufacturerMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerMaterial</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> MANUFACTURER_MATERIAL =
        new RequestForQuotationItemField<String>("ManufacturerMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @return Manufacturer Part Number
     */
    @SerializedName( "ManufacturerPartNmbr" )
    @JsonProperty( "ManufacturerPartNmbr" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartNmbr" )
    private String manufacturerPartNmbr;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartNmbr</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> MANUFACTURER_PART_NMBR =
        new RequestForQuotationItemField<String>("ManufacturerPartNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @return Number of a Manufacturer
     */
    @SerializedName( "Manufacturer" )
    @JsonProperty( "Manufacturer" )
    @Nullable
    @ODataField( odataName = "Manufacturer" )
    private String manufacturer;
    /**
     * Use with available fluent helpers to apply the <b>Manufacturer</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> MANUFACTURER =
        new RequestForQuotationItemField<String>("Manufacturer");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> MATERIAL_GROUP =
        new RequestForQuotationItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> PLANT = new RequestForQuotationItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "ManualDeliveryAddressID" )
    @JsonProperty( "ManualDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ManualDeliveryAddressID" )
    private String manualDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ManualDeliveryAddressID</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> MANUAL_DELIVERY_ADDRESS_ID =
        new RequestForQuotationItemField<String>("ManualDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @return Number of delivery address
     */
    @SerializedName( "ReferenceDeliveryAddressID" )
    @JsonProperty( "ReferenceDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ReferenceDeliveryAddressID" )
    private String referenceDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDeliveryAddressID</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> REFERENCE_DELIVERY_ADDRESS_ID =
        new RequestForQuotationItemField<String>("ReferenceDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> INCOTERMS_CLASSIFICATION =
        new RequestForQuotationItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new RequestForQuotationItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> INCOTERMS_LOCATION1 =
        new RequestForQuotationItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> INCOTERMS_LOCATION2 =
        new RequestForQuotationItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @return Delivery Date
     */
    @SerializedName( "ScheduleLineDeliveryDate" )
    @JsonProperty( "ScheduleLineDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduleLineDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryDate</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<LocalDateTime> SCHEDULE_LINE_DELIVERY_DATE =
        new RequestForQuotationItemField<LocalDateTime>("ScheduleLineDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new RequestForQuotationItemField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> ORDER_QUANTITY_UNIT =
        new RequestForQuotationItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Unit to Base Unit
     */
    @SerializedName( "OrderItemQtyToBaseQtyNmrtr" )
    @JsonProperty( "OrderItemQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderItemQtyToBaseQtyNmrtr" )
    private BigDecimal orderItemQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderItemQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<BigDecimal> ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR =
        new RequestForQuotationItemField<BigDecimal>("OrderItemQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Conversion of Order Unit to Base Unit
     */
    @SerializedName( "OrderItemQtyToBaseQtyDnmntr" )
    @JsonProperty( "OrderItemQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OrderItemQtyToBaseQtyDnmntr" )
    private BigDecimal orderItemQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrderItemQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<BigDecimal> ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR =
        new RequestForQuotationItemField<BigDecimal>("OrderItemQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> BASE_UNIT =
        new RequestForQuotationItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> PURCHASE_REQUISITION =
        new RequestForQuotationItemField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<String> PURCHASE_REQUISITION_ITEM =
        new RequestForQuotationItemField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoRecordUpdated</b>
     * </p>
     *
     * @return Indicator for Info Record Update
     */
    @SerializedName( "IsInfoRecordUpdated" )
    @JsonProperty( "IsInfoRecordUpdated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsInfoRecordUpdated" )
    private Boolean isInfoRecordUpdated;
    /**
     * Use with available fluent helpers to apply the <b>IsInfoRecordUpdated</b> field to query operations.
     *
     */
    public final static RequestForQuotationItemField<Boolean> IS_INFO_RECORD_UPDATED =
        new RequestForQuotationItemField<Boolean>("IsInfoRecordUpdated");

    @Nonnull
    @Override
    public Class<RequestForQuotationItem> getType()
    {
        return RequestForQuotationItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotationItem</b>
     * </p>
     *
     * @param requestForQuotationItem
     *            Item Number of Request For Quotation
     */
    public void setRequestForQuotationItem( @Nullable final String requestForQuotationItem )
    {
        rememberChangedField("RequestForQuotationItem", this.requestForQuotationItem);
        this.requestForQuotationItem = requestForQuotationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestForQuotation</b>
     * </p>
     *
     * @param requestForQuotation
     *            Purchasing Document Number
     */
    public void setRequestForQuotation( @Nullable final String requestForQuotation )
    {
        rememberChangedField("RequestForQuotation", this.requestForQuotation);
        this.requestForQuotation = requestForQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemText</b>
     * </p>
     *
     * @param purchasingDocumentItemText
     *            Short Text
     */
    public void setPurchasingDocumentItemText( @Nullable final String purchasingDocumentItemText )
    {
        rememberChangedField("PurchasingDocumentItemText", this.purchasingDocumentItemText);
        this.purchasingDocumentItemText = purchasingDocumentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @param manufacturerMaterial
     *            Manufacturer Material
     */
    public void setManufacturerMaterial( @Nullable final String manufacturerMaterial )
    {
        rememberChangedField("ManufacturerMaterial", this.manufacturerMaterial);
        this.manufacturerMaterial = manufacturerMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @param manufacturerPartNmbr
     *            Manufacturer Part Number
     */
    public void setManufacturerPartNmbr( @Nullable final String manufacturerPartNmbr )
    {
        rememberChangedField("ManufacturerPartNmbr", this.manufacturerPartNmbr);
        this.manufacturerPartNmbr = manufacturerPartNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @param manufacturer
     *            Number of a Manufacturer
     */
    public void setManufacturer( @Nullable final String manufacturer )
    {
        rememberChangedField("Manufacturer", this.manufacturer);
        this.manufacturer = manufacturer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @param manualDeliveryAddressID
     *            Manual address number in purchasing document item
     */
    public void setManualDeliveryAddressID( @Nullable final String manualDeliveryAddressID )
    {
        rememberChangedField("ManualDeliveryAddressID", this.manualDeliveryAddressID);
        this.manualDeliveryAddressID = manualDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @param referenceDeliveryAddressID
     *            Number of delivery address
     */
    public void setReferenceDeliveryAddressID( @Nullable final String referenceDeliveryAddressID )
    {
        rememberChangedField("ReferenceDeliveryAddressID", this.referenceDeliveryAddressID);
        this.referenceDeliveryAddressID = referenceDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @param scheduleLineDeliveryDate
     *            Delivery Date
     */
    public void setScheduleLineDeliveryDate( @Nullable final LocalDateTime scheduleLineDeliveryDate )
    {
        rememberChangedField("ScheduleLineDeliveryDate", this.scheduleLineDeliveryDate);
        this.scheduleLineDeliveryDate = scheduleLineDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Requested Quantity
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param orderItemQtyToBaseQtyNmrtr
     *            Numerator for Conversion of Order Unit to Base Unit
     */
    public void setOrderItemQtyToBaseQtyNmrtr( @Nullable final BigDecimal orderItemQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OrderItemQtyToBaseQtyNmrtr", this.orderItemQtyToBaseQtyNmrtr);
        this.orderItemQtyToBaseQtyNmrtr = orderItemQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param orderItemQtyToBaseQtyDnmntr
     *            Denominator for Conversion of Order Unit to Base Unit
     */
    public void setOrderItemQtyToBaseQtyDnmntr( @Nullable final BigDecimal orderItemQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OrderItemQtyToBaseQtyDnmntr", this.orderItemQtyToBaseQtyDnmntr);
        this.orderItemQtyToBaseQtyDnmntr = orderItemQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsInfoRecordUpdated</b>
     * </p>
     *
     * @param isInfoRecordUpdated
     *            Indicator for Info Record Update
     */
    public void setIsInfoRecordUpdated( @Nullable final Boolean isInfoRecordUpdated )
    {
        rememberChangedField("IsInfoRecordUpdated", this.isInfoRecordUpdated);
        this.isInfoRecordUpdated = isInfoRecordUpdated;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RequestForQuotationItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RequestForQuotationItem", getRequestForQuotationItem());
        result.put("RequestForQuotation", getRequestForQuotation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RequestForQuotationItem", getRequestForQuotationItem());
        values.put("RequestForQuotation", getRequestForQuotation());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentItemText", getPurchasingDocumentItemText());
        values.put("Material", getMaterial());
        values.put("ManufacturerMaterial", getManufacturerMaterial());
        values.put("ManufacturerPartNmbr", getManufacturerPartNmbr());
        values.put("Manufacturer", getManufacturer());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Plant", getPlant());
        values.put("ManualDeliveryAddressID", getManualDeliveryAddressID());
        values.put("ReferenceDeliveryAddressID", getReferenceDeliveryAddressID());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("ScheduleLineDeliveryDate", getScheduleLineDeliveryDate());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderItemQtyToBaseQtyNmrtr", getOrderItemQtyToBaseQtyNmrtr());
        values.put("OrderItemQtyToBaseQtyDnmntr", getOrderItemQtyToBaseQtyDnmntr());
        values.put("BaseUnit", getBaseUnit());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("IsInfoRecordUpdated", getIsInfoRecordUpdated());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RequestForQuotationItem") ) {
                final Object value = values.remove("RequestForQuotationItem");
                if( (value == null) || (!value.equals(getRequestForQuotationItem())) ) {
                    setRequestForQuotationItem(((String) value));
                }
            }
            if( values.containsKey("RequestForQuotation") ) {
                final Object value = values.remove("RequestForQuotation");
                if( (value == null) || (!value.equals(getRequestForQuotation())) ) {
                    setRequestForQuotation(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemText") ) {
                final Object value = values.remove("PurchasingDocumentItemText");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemText())) ) {
                    setPurchasingDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ManufacturerMaterial") ) {
                final Object value = values.remove("ManufacturerMaterial");
                if( (value == null) || (!value.equals(getManufacturerMaterial())) ) {
                    setManufacturerMaterial(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartNmbr") ) {
                final Object value = values.remove("ManufacturerPartNmbr");
                if( (value == null) || (!value.equals(getManufacturerPartNmbr())) ) {
                    setManufacturerPartNmbr(((String) value));
                }
            }
            if( values.containsKey("Manufacturer") ) {
                final Object value = values.remove("Manufacturer");
                if( (value == null) || (!value.equals(getManufacturer())) ) {
                    setManufacturer(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ManualDeliveryAddressID") ) {
                final Object value = values.remove("ManualDeliveryAddressID");
                if( (value == null) || (!value.equals(getManualDeliveryAddressID())) ) {
                    setManualDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("ReferenceDeliveryAddressID") ) {
                final Object value = values.remove("ReferenceDeliveryAddressID");
                if( (value == null) || (!value.equals(getReferenceDeliveryAddressID())) ) {
                    setReferenceDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryDate") ) {
                final Object value = values.remove("ScheduleLineDeliveryDate");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryDate())) ) {
                    setScheduleLineDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderItemQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OrderItemQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOrderItemQtyToBaseQtyNmrtr())) ) {
                    setOrderItemQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderItemQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OrderItemQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOrderItemQtyToBaseQtyDnmntr())) ) {
                    setOrderItemQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("IsInfoRecordUpdated") ) {
                final Object value = values.remove("IsInfoRecordUpdated");
                if( (value == null) || (!value.equals(getIsInfoRecordUpdated())) ) {
                    setIsInfoRecordUpdated(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RequestForQuotationItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RequestForQuotationItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RequestForQuotationItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RequestForQuotationItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService.DEFAULT_SERVICE_PATH);
    }

}
