/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.selectable.RequestForQuotationItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
 * RequestForQuotationItem} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class RequestForQuotationItemByKeyFluentHelper
    extends
    FluentHelperByKey<RequestForQuotationItemByKeyFluentHelper, RequestForQuotationItem, RequestForQuotationItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code RequestForQuotationItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code RequestForQuotationItem}
     * @param requestForQuotationItem
     *            Item Number of Request For Quotation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param requestForQuotation
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public RequestForQuotationItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String requestForQuotationItem,
        final String requestForQuotation )
    {
        super(servicePath, entityCollection);
        this.key.put("RequestForQuotationItem", requestForQuotationItem);
        this.key.put("RequestForQuotation", requestForQuotation);
    }

    @Override
    @Nonnull
    protected Class<RequestForQuotationItem> getEntityClass()
    {
        return RequestForQuotationItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
