/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link RequestsForQuotationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService RequestsForQuotationService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultRequestsForQuotationServiceBatch
    extends
    BatchFluentHelperBasic<RequestsForQuotationServiceBatch, RequestsForQuotationServiceBatchChangeSet>
    implements
    RequestsForQuotationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultRequestsForQuotationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRequestsForQuotationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultRequestsForQuotationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRequestsForQuotationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultRequestsForQuotationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultRequestsForQuotationServiceBatchChangeSet(this, service);
    }

}
