/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem;

/**
 * Implementation of the {@link RequestsForQuotationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService RequestsForQuotationService}.
 *
 */
public class DefaultRequestsForQuotationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<RequestsForQuotationServiceBatch, RequestsForQuotationServiceBatchChangeSet>
    implements
    RequestsForQuotationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService service;

    @SuppressWarnings( "deprecation" )
    DefaultRequestsForQuotationServiceBatchChangeSet(
        @Nonnull final DefaultRequestsForQuotationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultRequestsForQuotationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet createRequestForQuotation(
        @Nonnull final RequestForQuotation requestForQuotation )
    {
        return addRequestCreate(service::createRequestForQuotation, requestForQuotation);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet updateRequestForQuotation(
        @Nonnull final RequestForQuotation requestForQuotation )
    {
        return addRequestUpdate(service::updateRequestForQuotation, requestForQuotation);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet deleteRequestForQuotation(
        @Nonnull final RequestForQuotation requestForQuotation )
    {
        return addRequestDelete(service::deleteRequestForQuotation, requestForQuotation);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet createRequestForQuotationBidder(
        @Nonnull final RequestForQuotationBidder requestForQuotationBidder )
    {
        return addRequestCreate(service::createRequestForQuotationBidder, requestForQuotationBidder);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet updateRequestForQuotationBidder(
        @Nonnull final RequestForQuotationBidder requestForQuotationBidder )
    {
        return addRequestUpdate(service::updateRequestForQuotationBidder, requestForQuotationBidder);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet deleteRequestForQuotationBidder(
        @Nonnull final RequestForQuotationBidder requestForQuotationBidder )
    {
        return addRequestDelete(service::deleteRequestForQuotationBidder, requestForQuotationBidder);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet createRequestForQuotationItem(
        @Nonnull final RequestForQuotationItem requestForQuotationItem )
    {
        return addRequestCreate(service::createRequestForQuotationItem, requestForQuotationItem);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet updateRequestForQuotationItem(
        @Nonnull final RequestForQuotationItem requestForQuotationItem )
    {
        return addRequestUpdate(service::updateRequestForQuotationItem, requestForQuotationItem);
    }

    @Nonnull
    @Override
    public RequestsForQuotationServiceBatchChangeSet deleteRequestForQuotationItem(
        @Nonnull final RequestForQuotationItem requestForQuotationItem )
    {
        return addRequestDelete(service::deleteRequestForQuotationItem, requestForQuotationItem);
    }

}
