/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RequestsForQuotationService
 * RequestsForQuotationService}.
 *
 */
public interface RequestsForQuotationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<RequestsForQuotationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<RequestsForQuotationServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *            RequestForQuotation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        createRequestForQuotation( @Nonnull final RequestForQuotation requestForQuotation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *            RequestForQuotation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        updateRequestForQuotation( @Nonnull final RequestForQuotation requestForQuotation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity in the S/4HANA system.
     *
     * @param requestForQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *            RequestForQuotation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        deleteRequestForQuotation( @Nonnull final RequestForQuotation requestForQuotation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationBidder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *            RequestForQuotationBidder} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        createRequestForQuotationBidder( @Nonnull final RequestForQuotationBidder requestForQuotationBidder );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationBidder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *            RequestForQuotationBidder} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        updateRequestForQuotationBidder( @Nonnull final RequestForQuotationBidder requestForQuotationBidder );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity in the S/4HANA system.
     *
     * @param requestForQuotationBidder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *            RequestForQuotationBidder} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        deleteRequestForQuotationBidder( @Nonnull final RequestForQuotationBidder requestForQuotationBidder );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *            RequestForQuotationItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        createRequestForQuotationItem( @Nonnull final RequestForQuotationItem requestForQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *            RequestForQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        updateRequestForQuotationItem( @Nonnull final RequestForQuotationItem requestForQuotationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity in the S/4HANA system.
     *
     * @param requestForQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *            RequestForQuotationItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RequestsForQuotationServiceBatchChangeSet
        deleteRequestForQuotationItem( @Nonnull final RequestForQuotationItem requestForQuotationItem );

}
