/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
 * RequestForQuotationBidder}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.field.RequestForQuotationBidderField
 * RequestForQuotationBidderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.link.RequestForQuotationBidderLink
 * RequestForQuotationBidderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder#REQUEST_FOR_QUOTATION
 * REQUEST_FOR_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder#PARTNER_COUNTER
 * PARTNER_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder#SUPPLIER
 * SUPPLIER}</li>
 * </ul>
 *
 */
public interface RequestForQuotationBidderSelectable extends EntitySelectable<RequestForQuotationBidder>
{

}
