/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
 * RequestForQuotationItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.field.RequestForQuotationItemField
 * RequestForQuotationItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.link.RequestForQuotationItemLink
 * RequestForQuotationItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#REQUEST_FOR_QUOTATION_ITEM
 * REQUEST_FOR_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#REQUEST_FOR_QUOTATION
 * REQUEST_FOR_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#PURCHASING_DOCUMENT_ITEM_TEXT
 * PURCHASING_DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#MANUFACTURER_MATERIAL
 * MANUFACTURER_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#MANUFACTURER_PART_NMBR
 * MANUFACTURER_PART_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#MANUFACTURER
 * MANUFACTURER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#MANUAL_DELIVERY_ADDRESS_ID
 * MANUAL_DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#REFERENCE_DELIVERY_ADDRESS_ID
 * REFERENCE_DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#SCHEDULE_LINE_DELIVERY_DATE
 * SCHEDULE_LINE_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#SCHEDULE_LINE_ORDER_QUANTITY
 * SCHEDULE_LINE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR
 * ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR
 * ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem#IS_INFO_RECORD_UPDATED
 * IS_INFO_RECORD_UPDATED}</li>
 * </ul>
 *
 */
public interface RequestForQuotationItemSelectable extends EntitySelectable<RequestForQuotationItem>
{

}
