/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.field.ReservationDocumentHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.link.ReservationDocumentHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.selectable.ReservationDocumentHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ReservationDocumentHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReservationDocumentHeader extends VdmEntity<ReservationDocumentHeader>
{

    /**
     * Selector for all available fields of ReservationDocumentHeader.
     *
     */
    public final static ReservationDocumentHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @Key
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> RESERVATION =
        new ReservationDocumentHeaderField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> ORDER_ID =
        new ReservationDocumentHeaderField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> GOODS_MOVEMENT_TYPE =
        new ReservationDocumentHeaderField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> COST_CENTER =
        new ReservationDocumentHeaderField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> GOODS_RECIPIENT_NAME =
        new ReservationDocumentHeaderField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReservationDate</b>
     * </p>
     *
     * @return Base date for reservation
     */
    @SerializedName( "ReservationDate" )
    @JsonProperty( "ReservationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ReservationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime reservationDate;
    /**
     * Use with available fluent helpers to apply the <b>ReservationDate</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<LocalDateTime> RESERVATION_DATE =
        new ReservationDocumentHeaderField<LocalDateTime>("ReservationDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCheckedAgainstFactoryCal</b>
     * </p>
     *
     * @return Check date against factory calendar
     */
    @SerializedName( "IsCheckedAgainstFactoryCal" )
    @JsonProperty( "IsCheckedAgainstFactoryCal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCheckedAgainstFactoryCal" )
    private Boolean isCheckedAgainstFactoryCal;
    /**
     * Use with available fluent helpers to apply the <b>IsCheckedAgainstFactoryCal</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<Boolean> IS_CHECKED_AGAINST_FACTORY_CAL =
        new ReservationDocumentHeaderField<Boolean>("IsCheckedAgainstFactoryCal");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> CUSTOMER =
        new ReservationDocumentHeaderField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> WBS_ELEMENT =
        new ReservationDocumentHeaderField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> CONTROLLING_AREA =
        new ReservationDocumentHeaderField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> SALES_ORDER =
        new ReservationDocumentHeaderField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Item Number in Sales Order
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> SALES_ORDER_ITEM =
        new ReservationDocumentHeaderField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @return Delivery schedule for sales order
     */
    @SerializedName( "SalesOrderScheduleLine" )
    @JsonProperty( "SalesOrderScheduleLine" )
    @Nullable
    @ODataField( odataName = "SalesOrderScheduleLine" )
    private String salesOrderScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderScheduleLine</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> SALES_ORDER_SCHEDULE_LINE =
        new ReservationDocumentHeaderField<String>("SalesOrderScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AssetNumber</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "AssetNumber" )
    @JsonProperty( "AssetNumber" )
    @Nullable
    @ODataField( odataName = "AssetNumber" )
    private String assetNumber;
    /**
     * Use with available fluent helpers to apply the <b>AssetNumber</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> ASSET_NUMBER =
        new ReservationDocumentHeaderField<String>("AssetNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AssetSubNumber</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "AssetSubNumber" )
    @JsonProperty( "AssetSubNumber" )
    @Nullable
    @ODataField( odataName = "AssetSubNumber" )
    private String assetSubNumber;
    /**
     * Use with available fluent helpers to apply the <b>AssetSubNumber</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> ASSET_SUB_NUMBER =
        new ReservationDocumentHeaderField<String>("AssetSubNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>NetworkNumberForAcctAssgmt</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "NetworkNumberForAcctAssgmt" )
    @JsonProperty( "NetworkNumberForAcctAssgmt" )
    @Nullable
    @ODataField( odataName = "NetworkNumberForAcctAssgmt" )
    private String networkNumberForAcctAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>NetworkNumberForAcctAssgmt</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> NETWORK_NUMBER_FOR_ACCT_ASSGMT =
        new ReservationDocumentHeaderField<String>("NetworkNumberForAcctAssgmt");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @return Receiving plant/issuing plant
     */
    @SerializedName( "IssuingOrReceivingPlant" )
    @JsonProperty( "IssuingOrReceivingPlant" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingPlant" )
    private String issuingOrReceivingPlant;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingPlant</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> ISSUING_OR_RECEIVING_PLANT =
        new ReservationDocumentHeaderField<String>("IssuingOrReceivingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @return Receiving/issuing storage location
     */
    @SerializedName( "IssuingOrReceivingStorageLoc" )
    @JsonProperty( "IssuingOrReceivingStorageLoc" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingStorageLoc" )
    private String issuingOrReceivingStorageLoc;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingStorageLoc</b> field to query operations.
     *
     */
    public final static ReservationDocumentHeaderField<String> ISSUING_OR_RECEIVING_STORAGE_LOC =
        new ReservationDocumentHeaderField<String>("IssuingOrReceivingStorageLoc");
    /**
     * Navigation property <b>to_ReservationDocumentItem</b> for <b>ReservationDocumentHeader</b> to multiple
     * <b>ReservationDocumentItem</b>.
     *
     */
    @SerializedName( "to_ReservationDocumentItem" )
    @JsonProperty( "to_ReservationDocumentItem" )
    @ODataField( odataName = "to_ReservationDocumentItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ReservationDocumentItem> toReservationDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>to_ReservationDocumentItem</b> navigation property to query
     * operations.
     *
     */
    public final static ReservationDocumentHeaderLink<ReservationDocumentItem> TO_RESERVATION_DOCUMENT_ITEM =
        new ReservationDocumentHeaderLink<ReservationDocumentItem>("to_ReservationDocumentItem");

    @Nonnull
    @Override
    public Class<ReservationDocumentHeader> getType()
    {
        return ReservationDocumentHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ReservationDate</b>
     * </p>
     *
     * @param reservationDate
     *            Base date for reservation
     */
    public void setReservationDate( @Nullable final LocalDateTime reservationDate )
    {
        rememberChangedField("ReservationDate", this.reservationDate);
        this.reservationDate = reservationDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCheckedAgainstFactoryCal</b>
     * </p>
     *
     * @param isCheckedAgainstFactoryCal
     *            Check date against factory calendar
     */
    public void setIsCheckedAgainstFactoryCal( @Nullable final Boolean isCheckedAgainstFactoryCal )
    {
        rememberChangedField("IsCheckedAgainstFactoryCal", this.isCheckedAgainstFactoryCal);
        this.isCheckedAgainstFactoryCal = isCheckedAgainstFactoryCal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Account number of customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Item Number in Sales Order
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @param salesOrderScheduleLine
     *            Delivery schedule for sales order
     */
    public void setSalesOrderScheduleLine( @Nullable final String salesOrderScheduleLine )
    {
        rememberChangedField("SalesOrderScheduleLine", this.salesOrderScheduleLine);
        this.salesOrderScheduleLine = salesOrderScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AssetNumber</b>
     * </p>
     *
     * @param assetNumber
     *            Main Asset Number
     */
    public void setAssetNumber( @Nullable final String assetNumber )
    {
        rememberChangedField("AssetNumber", this.assetNumber);
        this.assetNumber = assetNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AssetSubNumber</b>
     * </p>
     *
     * @param assetSubNumber
     *            Asset Subnumber
     */
    public void setAssetSubNumber( @Nullable final String assetSubNumber )
    {
        rememberChangedField("AssetSubNumber", this.assetSubNumber);
        this.assetSubNumber = assetSubNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>NetworkNumberForAcctAssgmt</b>
     * </p>
     *
     * @param networkNumberForAcctAssgmt
     *            Network Number for Account Assignment
     */
    public void setNetworkNumberForAcctAssgmt( @Nullable final String networkNumberForAcctAssgmt )
    {
        rememberChangedField("NetworkNumberForAcctAssgmt", this.networkNumberForAcctAssgmt);
        this.networkNumberForAcctAssgmt = networkNumberForAcctAssgmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @param issuingOrReceivingPlant
     *            Receiving plant/issuing plant
     */
    public void setIssuingOrReceivingPlant( @Nullable final String issuingOrReceivingPlant )
    {
        rememberChangedField("IssuingOrReceivingPlant", this.issuingOrReceivingPlant);
        this.issuingOrReceivingPlant = issuingOrReceivingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @param issuingOrReceivingStorageLoc
     *            Receiving/issuing storage location
     */
    public void setIssuingOrReceivingStorageLoc( @Nullable final String issuingOrReceivingStorageLoc )
    {
        rememberChangedField("IssuingOrReceivingStorageLoc", this.issuingOrReceivingStorageLoc);
        this.issuingOrReceivingStorageLoc = issuingOrReceivingStorageLoc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ReservationDocumentHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Reservation", getReservation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Reservation", getReservation());
        values.put("OrderID", getOrderID());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("CostCenter", getCostCenter());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("ReservationDate", getReservationDate());
        values.put("IsCheckedAgainstFactoryCal", getIsCheckedAgainstFactoryCal());
        values.put("Customer", getCustomer());
        values.put("WBSElement", getWBSElement());
        values.put("ControllingArea", getControllingArea());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("SalesOrderScheduleLine", getSalesOrderScheduleLine());
        values.put("AssetNumber", getAssetNumber());
        values.put("AssetSubNumber", getAssetSubNumber());
        values.put("NetworkNumberForAcctAssgmt", getNetworkNumberForAcctAssgmt());
        values.put("IssuingOrReceivingPlant", getIssuingOrReceivingPlant());
        values.put("IssuingOrReceivingStorageLoc", getIssuingOrReceivingStorageLoc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("ReservationDate") ) {
                final Object value = values.remove("ReservationDate");
                if( (value == null) || (!value.equals(getReservationDate())) ) {
                    setReservationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IsCheckedAgainstFactoryCal") ) {
                final Object value = values.remove("IsCheckedAgainstFactoryCal");
                if( (value == null) || (!value.equals(getIsCheckedAgainstFactoryCal())) ) {
                    setIsCheckedAgainstFactoryCal(((Boolean) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrderScheduleLine") ) {
                final Object value = values.remove("SalesOrderScheduleLine");
                if( (value == null) || (!value.equals(getSalesOrderScheduleLine())) ) {
                    setSalesOrderScheduleLine(((String) value));
                }
            }
            if( values.containsKey("AssetNumber") ) {
                final Object value = values.remove("AssetNumber");
                if( (value == null) || (!value.equals(getAssetNumber())) ) {
                    setAssetNumber(((String) value));
                }
            }
            if( values.containsKey("AssetSubNumber") ) {
                final Object value = values.remove("AssetSubNumber");
                if( (value == null) || (!value.equals(getAssetSubNumber())) ) {
                    setAssetSubNumber(((String) value));
                }
            }
            if( values.containsKey("NetworkNumberForAcctAssgmt") ) {
                final Object value = values.remove("NetworkNumberForAcctAssgmt");
                if( (value == null) || (!value.equals(getNetworkNumberForAcctAssgmt())) ) {
                    setNetworkNumberForAcctAssgmt(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingPlant") ) {
                final Object value = values.remove("IssuingOrReceivingPlant");
                if( (value == null) || (!value.equals(getIssuingOrReceivingPlant())) ) {
                    setIssuingOrReceivingPlant(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingStorageLoc") ) {
                final Object value = values.remove("IssuingOrReceivingStorageLoc");
                if( (value == null) || (!value.equals(getIssuingOrReceivingStorageLoc())) ) {
                    setIssuingOrReceivingStorageLoc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ReservationDocumentItem") ) {
                final Object value = (values).remove("to_ReservationDocumentItem");
                if( value instanceof Iterable ) {
                    if( toReservationDocumentItem == null ) {
                        toReservationDocumentItem = Lists.newArrayList();
                    } else {
                        toReservationDocumentItem = Lists.newArrayList(toReservationDocumentItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ReservationDocumentItem entity;
                        if( toReservationDocumentItem.size() > i ) {
                            entity = toReservationDocumentItem.get(i);
                        } else {
                            entity = new ReservationDocumentItem();
                            toReservationDocumentItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReservationDocumentHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReservationDocumentHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReservationDocumentHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReservationDocumentHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toReservationDocumentItem != null ) {
            (values).put("to_ReservationDocumentItem", toReservationDocumentItem);
        }
        return values;
    }

    /**
     * Fetches the <b>ReservationDocumentItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReservationDocumentItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ReservationDocumentItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReservationDocumentItem> fetchReservationDocumentItem()
    {
        return fetchFieldAsList("to_ReservationDocumentItem", ReservationDocumentItem.class);
    }

    /**
     * Retrieval of associated <b>ReservationDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReservationDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_ReservationDocumentItem</b> of a queried <b>ReservationDocumentHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReservationDocumentItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReservationDocumentItem> getReservationDocumentItemOrFetch()
    {
        if( toReservationDocumentItem == null ) {
            toReservationDocumentItem = fetchReservationDocumentItem();
        }
        return toReservationDocumentItem;
    }

    /**
     * Retrieval of associated <b>ReservationDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReservationDocumentItem</b>.
     * <p>
     * If the navigation property for an entity <b>ReservationDocumentHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReservationDocumentItem</b> is already loaded, the
     *         result will contain the <b>ReservationDocumentItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ReservationDocumentItem>> getReservationDocumentItemIfPresent()
    {
        return Option.of(toReservationDocumentItem);
    }

    /**
     * Overwrites the list of associated <b>ReservationDocumentItem</b> entities for the loaded navigation property
     * <b>to_ReservationDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_ReservationDocumentItem</b> of a queried <b>ReservationDocumentHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ReservationDocumentItem</b> entities.
     */
    public void setReservationDocumentItem( @Nonnull final List<ReservationDocumentItem> value )
    {
        if( toReservationDocumentItem == null ) {
            toReservationDocumentItem = Lists.newArrayList();
        }
        toReservationDocumentItem.clear();
        toReservationDocumentItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ReservationDocumentItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ReservationDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_ReservationDocumentItem</b> of a queried <b>ReservationDocumentHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ReservationDocumentItem</b> entities.
     */
    public void addReservationDocumentItem( ReservationDocumentItem... entity )
    {
        if( toReservationDocumentItem == null ) {
            toReservationDocumentItem = Lists.newArrayList();
        }
        toReservationDocumentItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ReservationDocumentHeader instances.
     *
     */
    public final static class ReservationDocumentHeaderBuilder
    {

        private List<ReservationDocumentItem> toReservationDocumentItem = Lists.newArrayList();

        private ReservationDocumentHeader.ReservationDocumentHeaderBuilder toReservationDocumentItem(
            final List<ReservationDocumentItem> value )
        {
            toReservationDocumentItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReservationDocumentItem</b> for <b>ReservationDocumentHeader</b> to multiple
         * <b>ReservationDocumentItem</b>.
         *
         * @param value
         *            The ReservationDocumentItems to build this ReservationDocumentHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReservationDocumentHeader.ReservationDocumentHeaderBuilder reservationDocumentItem(
            ReservationDocumentItem... value )
        {
            return toReservationDocumentItem(Lists.newArrayList(value));
        }

    }

}
