/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.field.ReservationDocumentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.selectable.ReservationDocumentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Document Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ReservationDocumentItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReservationDocumentItem extends VdmEntity<ReservationDocumentItem>
{

    /**
     * Selector for all available fields of ReservationDocumentItem.
     *
     */
    public final static ReservationDocumentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @Key
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> RESERVATION =
        new ReservationDocumentItemField<String>("Reservation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Item Number of Reservation / Dependent Requirements
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> RESERVATION_ITEM =
        new ReservationDocumentItemField<String>("ReservationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecordType</b>
     * </p>
     *
     * @return Record type
     */
    @Key
    @SerializedName( "RecordType" )
    @JsonProperty( "RecordType" )
    @Nullable
    @ODataField( odataName = "RecordType" )
    private String recordType;
    /**
     * Use with available fluent helpers to apply the <b>RecordType</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> RECORD_TYPE =
        new ReservationDocumentItemField<String>("RecordType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> PRODUCT =
        new ReservationDocumentItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RequirementType</b>
     * </p>
     *
     * @return Requirement type
     */
    @SerializedName( "RequirementType" )
    @JsonProperty( "RequirementType" )
    @Nullable
    @ODataField( odataName = "RequirementType" )
    private String requirementType;
    /**
     * Use with available fluent helpers to apply the <b>RequirementType</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> REQUIREMENT_TYPE =
        new ReservationDocumentItemField<String>("RequirementType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @return Requirements date for the component
     */
    @SerializedName( "MatlCompRequirementDate" )
    @JsonProperty( "MatlCompRequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlCompRequirementDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementDate</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<LocalDateTime> MATL_COMP_REQUIREMENT_DATE =
        new ReservationDocumentItemField<LocalDateTime>("MatlCompRequirementDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> PLANT = new ReservationDocumentItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> MANUFACTURING_ORDER_OPERATION =
        new ReservationDocumentItemField<String>("ManufacturingOrderOperation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementIsAllowed</b>
     * </p>
     *
     * @return Goods Movement for Reservation Allowed
     */
    @SerializedName( "GoodsMovementIsAllowed" )
    @JsonProperty( "GoodsMovementIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsMovementIsAllowed" )
    private Boolean goodsMovementIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementIsAllowed</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<Boolean> GOODS_MOVEMENT_IS_ALLOWED =
        new ReservationDocumentItemField<Boolean>("GoodsMovementIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> STORAGE_LOCATION =
        new ReservationDocumentItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> BATCH = new ReservationDocumentItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Indicator
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> DEBIT_CREDIT_CODE =
        new ReservationDocumentItemField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> BASE_UNIT =
        new ReservationDocumentItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> GL_ACCOUNT =
        new ReservationDocumentItemField<String>("GLAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResvnAccountIsEnteredManually</b>
     * </p>
     *
     * @return Acct entered manually
     */
    @SerializedName( "ResvnAccountIsEnteredManually" )
    @JsonProperty( "ResvnAccountIsEnteredManually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ResvnAccountIsEnteredManually" )
    private Boolean resvnAccountIsEnteredManually;
    /**
     * Use with available fluent helpers to apply the <b>ResvnAccountIsEnteredManually</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<Boolean> RESVN_ACCOUNT_IS_ENTERED_MANUALLY =
        new ReservationDocumentItemField<Boolean>("ResvnAccountIsEnteredManually");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> GOODS_MOVEMENT_TYPE =
        new ReservationDocumentItemField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> ENTRY_UNIT =
        new ReservationDocumentItemField<String>("EntryUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @return Quantity is fixed
     */
    @SerializedName( "QuantityIsFixed" )
    @JsonProperty( "QuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "QuantityIsFixed" )
    private Boolean quantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsFixed</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<Boolean> QUANTITY_IS_FIXED =
        new ReservationDocumentItemField<Boolean>("QuantityIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> COMPANY_CODE_CURRENCY =
        new ReservationDocumentItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @return Receiving plant/issuing plant
     */
    @SerializedName( "IssuingOrReceivingPlant" )
    @JsonProperty( "IssuingOrReceivingPlant" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingPlant" )
    private String issuingOrReceivingPlant;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingPlant</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> ISSUING_OR_RECEIVING_PLANT =
        new ReservationDocumentItemField<String>("IssuingOrReceivingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @return Receiving/issuing storage location
     */
    @SerializedName( "IssuingOrReceivingStorageLoc" )
    @JsonProperty( "IssuingOrReceivingStorageLoc" )
    @Nullable
    @ODataField( odataName = "IssuingOrReceivingStorageLoc" )
    private String issuingOrReceivingStorageLoc;
    /**
     * Use with available fluent helpers to apply the <b>IssuingOrReceivingStorageLoc</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> ISSUING_OR_RECEIVING_STORAGE_LOC =
        new ReservationDocumentItemField<String>("IssuingOrReceivingStorageLoc");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> PURCHASING_DOCUMENT =
        new ReservationDocumentItemField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> PURCHASING_DOCUMENT_ITEM =
        new ReservationDocumentItemField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> SUPPLIER =
        new ReservationDocumentItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmRequiredQtyInBaseUnit</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "ResvnItmRequiredQtyInBaseUnit" )
    @JsonProperty( "ResvnItmRequiredQtyInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ResvnItmRequiredQtyInBaseUnit" )
    private BigDecimal resvnItmRequiredQtyInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ResvnItmRequiredQtyInBaseUnit</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<BigDecimal> RESVN_ITM_REQUIRED_QTY_IN_BASE_UNIT =
        new ReservationDocumentItemField<BigDecimal>("ResvnItmRequiredQtyInBaseUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItemIsFinallyIssued</b>
     * </p>
     *
     * @return Final Issue for Reservation
     */
    @SerializedName( "ReservationItemIsFinallyIssued" )
    @JsonProperty( "ReservationItemIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationItemIsFinallyIssued" )
    private Boolean reservationItemIsFinallyIssued;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItemIsFinallyIssued</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<Boolean> RESERVATION_ITEM_IS_FINALLY_ISSUED =
        new ReservationDocumentItemField<Boolean>("ReservationItemIsFinallyIssued");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItmIsMarkedForDeltn</b>
     * </p>
     *
     * @return Item is deleted
     */
    @SerializedName( "ReservationItmIsMarkedForDeltn" )
    @JsonProperty( "ReservationItmIsMarkedForDeltn" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationItmIsMarkedForDeltn" )
    private Boolean reservationItmIsMarkedForDeltn;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItmIsMarkedForDeltn</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<Boolean> RESERVATION_ITM_IS_MARKED_FOR_DELTN =
        new ReservationDocumentItemField<Boolean>("ReservationItmIsMarkedForDeltn");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmRequiredQtyInEntryUnit</b>
     * </p>
     *
     * @return Quantity in unit of entry
     */
    @SerializedName( "ResvnItmRequiredQtyInEntryUnit" )
    @JsonProperty( "ResvnItmRequiredQtyInEntryUnit" )
    @Nullable
    @ODataField( odataName = "ResvnItmRequiredQtyInEntryUnit" )
    private BigDecimal resvnItmRequiredQtyInEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>ResvnItmRequiredQtyInEntryUnit</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<BigDecimal> RESVN_ITM_REQUIRED_QTY_IN_ENTRY_UNIT =
        new ReservationDocumentItemField<BigDecimal>("ResvnItmRequiredQtyInEntryUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmWithdrawnQtyInBaseUnit</b>
     * </p>
     *
     * @return Quantity withdrawn
     */
    @SerializedName( "ResvnItmWithdrawnQtyInBaseUnit" )
    @JsonProperty( "ResvnItmWithdrawnQtyInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ResvnItmWithdrawnQtyInBaseUnit" )
    private BigDecimal resvnItmWithdrawnQtyInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ResvnItmWithdrawnQtyInBaseUnit</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<BigDecimal> RESVN_ITM_WITHDRAWN_QTY_IN_BASE_UNIT =
        new ReservationDocumentItemField<BigDecimal>("ResvnItmWithdrawnQtyInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmWithdrawnAmtInCCCrcy</b>
     * </p>
     *
     * @return Value Withdrawn
     */
    @SerializedName( "ResvnItmWithdrawnAmtInCCCrcy" )
    @JsonProperty( "ResvnItmWithdrawnAmtInCCCrcy" )
    @Nullable
    @ODataField( odataName = "ResvnItmWithdrawnAmtInCCCrcy" )
    private BigDecimal resvnItmWithdrawnAmtInCCCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ResvnItmWithdrawnAmtInCCCrcy</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<BigDecimal> RESVN_ITM_WITHDRAWN_AMT_IN_CC_CRCY =
        new ReservationDocumentItemField<BigDecimal>("ResvnItmWithdrawnAmtInCCCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> GOODS_RECIPIENT_NAME =
        new ReservationDocumentItemField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> UNLOADING_POINT_NAME =
        new ReservationDocumentItemField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "ReservationItemText" )
    @JsonProperty( "ReservationItemText" )
    @Nullable
    @ODataField( odataName = "ReservationItemText" )
    private String reservationItemText;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItemText</b> field to query operations.
     *
     */
    public final static ReservationDocumentItemField<String> RESERVATION_ITEM_TEXT =
        new ReservationDocumentItemField<String>("ReservationItemText");

    @Nonnull
    @Override
    public Class<ReservationDocumentItem> getType()
    {
        return ReservationDocumentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Item Number of Reservation / Dependent Requirements
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecordType</b>
     * </p>
     *
     * @param recordType
     *            Record type
     */
    public void setRecordType( @Nullable final String recordType )
    {
        rememberChangedField("RecordType", this.recordType);
        this.recordType = recordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RequirementType</b>
     * </p>
     *
     * @param requirementType
     *            Requirement type
     */
    public void setRequirementType( @Nullable final String requirementType )
    {
        rememberChangedField("RequirementType", this.requirementType);
        this.requirementType = requirementType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @param matlCompRequirementDate
     *            Requirements date for the component
     */
    public void setMatlCompRequirementDate( @Nullable final LocalDateTime matlCompRequirementDate )
    {
        rememberChangedField("MatlCompRequirementDate", this.matlCompRequirementDate);
        this.matlCompRequirementDate = matlCompRequirementDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Operation/Activity Number
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementIsAllowed</b>
     * </p>
     *
     * @param goodsMovementIsAllowed
     *            Goods Movement for Reservation Allowed
     */
    public void setGoodsMovementIsAllowed( @Nullable final Boolean goodsMovementIsAllowed )
    {
        rememberChangedField("GoodsMovementIsAllowed", this.goodsMovementIsAllowed);
        this.goodsMovementIsAllowed = goodsMovementIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Indicator
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResvnAccountIsEnteredManually</b>
     * </p>
     *
     * @param resvnAccountIsEnteredManually
     *            Acct entered manually
     */
    public void setResvnAccountIsEnteredManually( @Nullable final Boolean resvnAccountIsEnteredManually )
    {
        rememberChangedField("ResvnAccountIsEnteredManually", this.resvnAccountIsEnteredManually);
        this.resvnAccountIsEnteredManually = resvnAccountIsEnteredManually;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @param quantityIsFixed
     *            Quantity is fixed
     */
    public void setQuantityIsFixed( @Nullable final Boolean quantityIsFixed )
    {
        rememberChangedField("QuantityIsFixed", this.quantityIsFixed);
        this.quantityIsFixed = quantityIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Currency Key
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingPlant</b>
     * </p>
     *
     * @param issuingOrReceivingPlant
     *            Receiving plant/issuing plant
     */
    public void setIssuingOrReceivingPlant( @Nullable final String issuingOrReceivingPlant )
    {
        rememberChangedField("IssuingOrReceivingPlant", this.issuingOrReceivingPlant);
        this.issuingOrReceivingPlant = issuingOrReceivingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IssuingOrReceivingStorageLoc</b>
     * </p>
     *
     * @param issuingOrReceivingStorageLoc
     *            Receiving/issuing storage location
     */
    public void setIssuingOrReceivingStorageLoc( @Nullable final String issuingOrReceivingStorageLoc )
    {
        rememberChangedField("IssuingOrReceivingStorageLoc", this.issuingOrReceivingStorageLoc);
        this.issuingOrReceivingStorageLoc = issuingOrReceivingStorageLoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Item Number of Purchasing Document
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmRequiredQtyInBaseUnit</b>
     * </p>
     *
     * @param resvnItmRequiredQtyInBaseUnit
     *            Requirement Quantity
     */
    public void setResvnItmRequiredQtyInBaseUnit( @Nullable final BigDecimal resvnItmRequiredQtyInBaseUnit )
    {
        rememberChangedField("ResvnItmRequiredQtyInBaseUnit", this.resvnItmRequiredQtyInBaseUnit);
        this.resvnItmRequiredQtyInBaseUnit = resvnItmRequiredQtyInBaseUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItemIsFinallyIssued</b>
     * </p>
     *
     * @param reservationItemIsFinallyIssued
     *            Final Issue for Reservation
     */
    public void setReservationItemIsFinallyIssued( @Nullable final Boolean reservationItemIsFinallyIssued )
    {
        rememberChangedField("ReservationItemIsFinallyIssued", this.reservationItemIsFinallyIssued);
        this.reservationItemIsFinallyIssued = reservationItemIsFinallyIssued;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItmIsMarkedForDeltn</b>
     * </p>
     *
     * @param reservationItmIsMarkedForDeltn
     *            Item is deleted
     */
    public void setReservationItmIsMarkedForDeltn( @Nullable final Boolean reservationItmIsMarkedForDeltn )
    {
        rememberChangedField("ReservationItmIsMarkedForDeltn", this.reservationItmIsMarkedForDeltn);
        this.reservationItmIsMarkedForDeltn = reservationItmIsMarkedForDeltn;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmRequiredQtyInEntryUnit</b>
     * </p>
     *
     * @param resvnItmRequiredQtyInEntryUnit
     *            Quantity in unit of entry
     */
    public void setResvnItmRequiredQtyInEntryUnit( @Nullable final BigDecimal resvnItmRequiredQtyInEntryUnit )
    {
        rememberChangedField("ResvnItmRequiredQtyInEntryUnit", this.resvnItmRequiredQtyInEntryUnit);
        this.resvnItmRequiredQtyInEntryUnit = resvnItmRequiredQtyInEntryUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmWithdrawnQtyInBaseUnit</b>
     * </p>
     *
     * @param resvnItmWithdrawnQtyInBaseUnit
     *            Quantity withdrawn
     */
    public void setResvnItmWithdrawnQtyInBaseUnit( @Nullable final BigDecimal resvnItmWithdrawnQtyInBaseUnit )
    {
        rememberChangedField("ResvnItmWithdrawnQtyInBaseUnit", this.resvnItmWithdrawnQtyInBaseUnit);
        this.resvnItmWithdrawnQtyInBaseUnit = resvnItmWithdrawnQtyInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResvnItmWithdrawnAmtInCCCrcy</b>
     * </p>
     *
     * @param resvnItmWithdrawnAmtInCCCrcy
     *            Value Withdrawn
     */
    public void setResvnItmWithdrawnAmtInCCCrcy( @Nullable final BigDecimal resvnItmWithdrawnAmtInCCCrcy )
    {
        rememberChangedField("ResvnItmWithdrawnAmtInCCCrcy", this.resvnItmWithdrawnAmtInCCCrcy);
        this.resvnItmWithdrawnAmtInCCCrcy = resvnItmWithdrawnAmtInCCCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItemText</b>
     * </p>
     *
     * @param reservationItemText
     *            Item Text
     */
    public void setReservationItemText( @Nullable final String reservationItemText )
    {
        rememberChangedField("ReservationItemText", this.reservationItemText);
        this.reservationItemText = reservationItemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ReservationDocumentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Reservation", getReservation());
        result.put("ReservationItem", getReservationItem());
        result.put("RecordType", getRecordType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("RecordType", getRecordType());
        values.put("Product", getProduct());
        values.put("RequirementType", getRequirementType());
        values.put("MatlCompRequirementDate", getMatlCompRequirementDate());
        values.put("Plant", getPlant());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("GoodsMovementIsAllowed", getGoodsMovementIsAllowed());
        values.put("StorageLocation", getStorageLocation());
        values.put("Batch", getBatch());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("BaseUnit", getBaseUnit());
        values.put("GLAccount", getGLAccount());
        values.put("ResvnAccountIsEnteredManually", getResvnAccountIsEnteredManually());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("EntryUnit", getEntryUnit());
        values.put("QuantityIsFixed", getQuantityIsFixed());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("IssuingOrReceivingPlant", getIssuingOrReceivingPlant());
        values.put("IssuingOrReceivingStorageLoc", getIssuingOrReceivingStorageLoc());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("Supplier", getSupplier());
        values.put("ResvnItmRequiredQtyInBaseUnit", getResvnItmRequiredQtyInBaseUnit());
        values.put("ReservationItemIsFinallyIssued", getReservationItemIsFinallyIssued());
        values.put("ReservationItmIsMarkedForDeltn", getReservationItmIsMarkedForDeltn());
        values.put("ResvnItmRequiredQtyInEntryUnit", getResvnItmRequiredQtyInEntryUnit());
        values.put("ResvnItmWithdrawnQtyInBaseUnit", getResvnItmWithdrawnQtyInBaseUnit());
        values.put("ResvnItmWithdrawnAmtInCCCrcy", getResvnItmWithdrawnAmtInCCCrcy());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("ReservationItemText", getReservationItemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("RecordType") ) {
                final Object value = values.remove("RecordType");
                if( (value == null) || (!value.equals(getRecordType())) ) {
                    setRecordType(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("RequirementType") ) {
                final Object value = values.remove("RequirementType");
                if( (value == null) || (!value.equals(getRequirementType())) ) {
                    setRequirementType(((String) value));
                }
            }
            if( values.containsKey("MatlCompRequirementDate") ) {
                final Object value = values.remove("MatlCompRequirementDate");
                if( (value == null) || (!value.equals(getMatlCompRequirementDate())) ) {
                    setMatlCompRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("GoodsMovementIsAllowed") ) {
                final Object value = values.remove("GoodsMovementIsAllowed");
                if( (value == null) || (!value.equals(getGoodsMovementIsAllowed())) ) {
                    setGoodsMovementIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("ResvnAccountIsEnteredManually") ) {
                final Object value = values.remove("ResvnAccountIsEnteredManually");
                if( (value == null) || (!value.equals(getResvnAccountIsEnteredManually())) ) {
                    setResvnAccountIsEnteredManually(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("QuantityIsFixed") ) {
                final Object value = values.remove("QuantityIsFixed");
                if( (value == null) || (!value.equals(getQuantityIsFixed())) ) {
                    setQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingPlant") ) {
                final Object value = values.remove("IssuingOrReceivingPlant");
                if( (value == null) || (!value.equals(getIssuingOrReceivingPlant())) ) {
                    setIssuingOrReceivingPlant(((String) value));
                }
            }
            if( values.containsKey("IssuingOrReceivingStorageLoc") ) {
                final Object value = values.remove("IssuingOrReceivingStorageLoc");
                if( (value == null) || (!value.equals(getIssuingOrReceivingStorageLoc())) ) {
                    setIssuingOrReceivingStorageLoc(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("ResvnItmRequiredQtyInBaseUnit") ) {
                final Object value = values.remove("ResvnItmRequiredQtyInBaseUnit");
                if( (value == null) || (!value.equals(getResvnItmRequiredQtyInBaseUnit())) ) {
                    setResvnItmRequiredQtyInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReservationItemIsFinallyIssued") ) {
                final Object value = values.remove("ReservationItemIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationItemIsFinallyIssued())) ) {
                    setReservationItemIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("ReservationItmIsMarkedForDeltn") ) {
                final Object value = values.remove("ReservationItmIsMarkedForDeltn");
                if( (value == null) || (!value.equals(getReservationItmIsMarkedForDeltn())) ) {
                    setReservationItmIsMarkedForDeltn(((Boolean) value));
                }
            }
            if( values.containsKey("ResvnItmRequiredQtyInEntryUnit") ) {
                final Object value = values.remove("ResvnItmRequiredQtyInEntryUnit");
                if( (value == null) || (!value.equals(getResvnItmRequiredQtyInEntryUnit())) ) {
                    setResvnItmRequiredQtyInEntryUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ResvnItmWithdrawnQtyInBaseUnit") ) {
                final Object value = values.remove("ResvnItmWithdrawnQtyInBaseUnit");
                if( (value == null) || (!value.equals(getResvnItmWithdrawnQtyInBaseUnit())) ) {
                    setResvnItmWithdrawnQtyInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ResvnItmWithdrawnAmtInCCCrcy") ) {
                final Object value = values.remove("ResvnItmWithdrawnAmtInCCCrcy");
                if( (value == null) || (!value.equals(getResvnItmWithdrawnAmtInCCCrcy())) ) {
                    setResvnItmWithdrawnAmtInCCCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("ReservationItemText") ) {
                final Object value = values.remove("ReservationItemText");
                if( (value == null) || (!value.equals(getReservationItemText())) ) {
                    setReservationItemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReservationDocumentItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReservationDocumentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReservationDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReservationDocumentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService.DEFAULT_SERVICE_PATH);
    }

}
