/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ReservationDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService ReservationDocumentService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultReservationDocumentServiceBatch
    extends
    BatchFluentHelperBasic<ReservationDocumentServiceBatch, ReservationDocumentServiceBatchChangeSet>
    implements
    ReservationDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultReservationDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultReservationDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultReservationDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultReservationDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultReservationDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ReservationDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultReservationDocumentServiceBatchChangeSet(this, service);
    }

}
