/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader;

/**
 * Implementation of the {@link ReservationDocumentServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService ReservationDocumentService}.
 *
 */
public class DefaultReservationDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ReservationDocumentServiceBatch, ReservationDocumentServiceBatchChangeSet>
    implements
    ReservationDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultReservationDocumentServiceBatchChangeSet(
        @Nonnull final DefaultReservationDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultReservationDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ReservationDocumentServiceBatchChangeSet createReservationDocumentHeader(
        @Nonnull final ReservationDocumentHeader reservationDocumentHeader )
    {
        return addRequestCreate(service::createReservationDocumentHeader, reservationDocumentHeader);
    }

    @Nonnull
    @Override
    public ReservationDocumentServiceBatchChangeSet deleteReservationDocumentHeader(
        @Nonnull final ReservationDocumentHeader reservationDocumentHeader )
    {
        return addRequestDelete(service::deleteReservationDocumentHeader, reservationDocumentHeader);
    }

}
