/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ReservationDocumentService
 * ReservationDocumentService}.
 *
 */
public interface ReservationDocumentServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ReservationDocumentServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ReservationDocumentServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     * ReservationDocumentHeader} entity and save it to the S/4HANA system.
     *
     * @param reservationDocumentHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *            ReservationDocumentHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ReservationDocumentServiceBatchChangeSet
        createReservationDocumentHeader( @Nonnull final ReservationDocumentHeader reservationDocumentHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     * ReservationDocumentHeader} entity in the S/4HANA system.
     *
     * @param reservationDocumentHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *            ReservationDocumentHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ReservationDocumentServiceBatchChangeSet
        deleteReservationDocumentHeader( @Nonnull final ReservationDocumentHeader reservationDocumentHeader );

}
