/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
 * ReservationDocumentHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.field.ReservationDocumentHeaderField
 * ReservationDocumentHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.link.ReservationDocumentHeaderLink
 * ReservationDocumentHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#RESERVATION_DATE
 * RESERVATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#IS_CHECKED_AGAINST_FACTORY_CAL
 * IS_CHECKED_AGAINST_FACTORY_CAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#SALES_ORDER_SCHEDULE_LINE
 * SALES_ORDER_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#ASSET_NUMBER
 * ASSET_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#ASSET_SUB_NUMBER
 * ASSET_SUB_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#NETWORK_NUMBER_FOR_ACCT_ASSGMT
 * NETWORK_NUMBER_FOR_ACCT_ASSGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#ISSUING_OR_RECEIVING_PLANT
 * ISSUING_OR_RECEIVING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#ISSUING_OR_RECEIVING_STORAGE_LOC
 * ISSUING_OR_RECEIVING_STORAGE_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader#TO_RESERVATION_DOCUMENT_ITEM
 * TO_RESERVATION_DOCUMENT_ITEM}</li>
 * </ul>
 *
 */
public interface ReservationDocumentHeaderSelectable extends EntitySelectable<ReservationDocumentHeader>
{

}
