/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.field.RetroBillingUsageTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable.RetroBillingUsageTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Description of Retro-Billing Usage Indicator
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RetroBillingUsageTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RetroBillingUsageText extends VdmEntity<RetroBillingUsageText>
{

    /**
     * Selector for all available fields of RetroBillingUsageText.
     *
     */
    public final static RetroBillingUsageTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetroBillingUsage</b>
     * </p>
     *
     * @return Use of Order Reason for Retroactive Billing
     */
    @Key
    @SerializedName( "RetroBillingUsage" )
    @JsonProperty( "RetroBillingUsage" )
    @Nullable
    @ODataField( odataName = "RetroBillingUsage" )
    private String retroBillingUsage;
    /**
     * Use with available fluent helpers to apply the <b>RetroBillingUsage</b> field to query operations.
     *
     */
    public final static RetroBillingUsageTextField<String> RETRO_BILLING_USAGE =
        new RetroBillingUsageTextField<String>("RetroBillingUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static RetroBillingUsageTextField<String> LANGUAGE =
        new RetroBillingUsageTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RetroBillingUsageDesc</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "RetroBillingUsageDesc" )
    @JsonProperty( "RetroBillingUsageDesc" )
    @Nullable
    @ODataField( odataName = "RetroBillingUsageDesc" )
    private String retroBillingUsageDesc;
    /**
     * Use with available fluent helpers to apply the <b>RetroBillingUsageDesc</b> field to query operations.
     *
     */
    public final static RetroBillingUsageTextField<String> RETRO_BILLING_USAGE_DESC =
        new RetroBillingUsageTextField<String>("RetroBillingUsageDesc");

    @Nonnull
    @Override
    public Class<RetroBillingUsageText> getType()
    {
        return RetroBillingUsageText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetroBillingUsage</b>
     * </p>
     *
     * @param retroBillingUsage
     *            Use of Order Reason for Retroactive Billing
     */
    public void setRetroBillingUsage( @Nullable final String retroBillingUsage )
    {
        rememberChangedField("RetroBillingUsage", this.retroBillingUsage);
        this.retroBillingUsage = retroBillingUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RetroBillingUsageDesc</b>
     * </p>
     *
     * @param retroBillingUsageDesc
     *            Short Text for Fixed Values
     */
    public void setRetroBillingUsageDesc( @Nullable final String retroBillingUsageDesc )
    {
        rememberChangedField("RetroBillingUsageDesc", this.retroBillingUsageDesc);
        this.retroBillingUsageDesc = retroBillingUsageDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RetroBillingUsageText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RetroBillingUsage", getRetroBillingUsage());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RetroBillingUsage", getRetroBillingUsage());
        values.put("Language", getLanguage());
        values.put("RetroBillingUsageDesc", getRetroBillingUsageDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RetroBillingUsage") ) {
                final Object value = values.remove("RetroBillingUsage");
                if( (value == null) || (!value.equals(getRetroBillingUsage())) ) {
                    setRetroBillingUsage(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("RetroBillingUsageDesc") ) {
                final Object value = values.remove("RetroBillingUsageDesc");
                if( (value == null) || (!value.equals(getRetroBillingUsageDesc())) ) {
                    setRetroBillingUsageDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RetroBillingUsageTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RetroBillingUsageTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RetroBillingUsageTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RetroBillingUsageTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService.DEFAULT_SERVICE_PATH);
    }

}
