/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable.RetroBillingUsageTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.RetroBillingUsageText
 * RetroBillingUsageText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class RetroBillingUsageTextByKeyFluentHelper
    extends
    FluentHelperByKey<RetroBillingUsageTextByKeyFluentHelper, RetroBillingUsageText, RetroBillingUsageTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.RetroBillingUsageText
     * RetroBillingUsageText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code RetroBillingUsageText}
     * @param retroBillingUsage
     *            Use of Order Reason for Retroactive Billing
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code RetroBillingUsageText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public RetroBillingUsageTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String retroBillingUsage,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("RetroBillingUsage", retroBillingUsage);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<RetroBillingUsageText> getEntityClass()
    {
        return RetroBillingUsageText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
