/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.field.SDDocumentReasonField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.link.SDDocumentReasonLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable.SDDocumentReasonSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Order Reason ID and Self-Billing Processing Indicators
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SDDocumentReasonType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SDDocumentReason extends VdmEntity<SDDocumentReason>
{

    /**
     * Selector for all available fields of SDDocumentReason.
     *
     */
    public final static SDDocumentReasonSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @Key
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static SDDocumentReasonField<String> SD_DOCUMENT_REASON =
        new SDDocumentReasonField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetroBillingUsage</b>
     * </p>
     *
     * @return Use of Order Reason for Retroactive Billing
     */
    @SerializedName( "RetroBillingUsage" )
    @JsonProperty( "RetroBillingUsage" )
    @Nullable
    @ODataField( odataName = "RetroBillingUsage" )
    private String retroBillingUsage;
    /**
     * Use with available fluent helpers to apply the <b>RetroBillingUsage</b> field to query operations.
     *
     */
    public final static SDDocumentReasonField<String> RETRO_BILLING_USAGE =
        new SDDocumentReasonField<String>("RetroBillingUsage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SelfBillingValueItem</b>
     * </p>
     *
     * @return Value Item for Self-Billing
     */
    @SerializedName( "SelfBillingValueItem" )
    @JsonProperty( "SelfBillingValueItem" )
    @Nullable
    @ODataField( odataName = "SelfBillingValueItem" )
    private String selfBillingValueItem;
    /**
     * Use with available fluent helpers to apply the <b>SelfBillingValueItem</b> field to query operations.
     *
     */
    public final static SDDocumentReasonField<String> SELF_BILLING_VALUE_ITEM =
        new SDDocumentReasonField<String>("SelfBillingValueItem");
    /**
     * Navigation property <b>to_RetroBillingUsageText</b> for <b>SDDocumentReason</b> to multiple
     * <b>RetroBillingUsageText</b>.
     *
     */
    @SerializedName( "to_RetroBillingUsageText" )
    @JsonProperty( "to_RetroBillingUsageText" )
    @ODataField( odataName = "to_RetroBillingUsageText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RetroBillingUsageText> toRetroBillingUsageText;
    /**
     * Navigation property <b>to_SDDocumentReasonText</b> for <b>SDDocumentReason</b> to multiple
     * <b>SDDocumentReasonText</b>.
     *
     */
    @SerializedName( "to_SDDocumentReasonText" )
    @JsonProperty( "to_SDDocumentReasonText" )
    @ODataField( odataName = "to_SDDocumentReasonText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SDDocumentReasonText> toSDDocumentReasonText;
    /**
     * Navigation property <b>to_SelfBillingValueItemText</b> for <b>SDDocumentReason</b> to multiple
     * <b>SelfBillingValueItemText</b>.
     *
     */
    @SerializedName( "to_SelfBillingValueItemText" )
    @JsonProperty( "to_SelfBillingValueItemText" )
    @ODataField( odataName = "to_SelfBillingValueItemText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SelfBillingValueItemText> toSelfBillingValueItemText;
    /**
     * Use with available fluent helpers to apply the <b>to_RetroBillingUsageText</b> navigation property to query
     * operations.
     *
     */
    public final static SDDocumentReasonLink<RetroBillingUsageText> TO_RETRO_BILLING_USAGE_TEXT =
        new SDDocumentReasonLink<RetroBillingUsageText>("to_RetroBillingUsageText");
    /**
     * Use with available fluent helpers to apply the <b>to_SDDocumentReasonText</b> navigation property to query
     * operations.
     *
     */
    public final static SDDocumentReasonLink<SDDocumentReasonText> TO_SD_DOCUMENT_REASON_TEXT =
        new SDDocumentReasonLink<SDDocumentReasonText>("to_SDDocumentReasonText");
    /**
     * Use with available fluent helpers to apply the <b>to_SelfBillingValueItemText</b> navigation property to query
     * operations.
     *
     */
    public final static SDDocumentReasonLink<SelfBillingValueItemText> TO_SELF_BILLING_VALUE_ITEM_TEXT =
        new SDDocumentReasonLink<SelfBillingValueItemText>("to_SelfBillingValueItemText");

    @Nonnull
    @Override
    public Class<SDDocumentReason> getType()
    {
        return SDDocumentReason.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RetroBillingUsage</b>
     * </p>
     *
     * @param retroBillingUsage
     *            Use of Order Reason for Retroactive Billing
     */
    public void setRetroBillingUsage( @Nullable final String retroBillingUsage )
    {
        rememberChangedField("RetroBillingUsage", this.retroBillingUsage);
        this.retroBillingUsage = retroBillingUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SelfBillingValueItem</b>
     * </p>
     *
     * @param selfBillingValueItem
     *            Value Item for Self-Billing
     */
    public void setSelfBillingValueItem( @Nullable final String selfBillingValueItem )
    {
        rememberChangedField("SelfBillingValueItem", this.selfBillingValueItem);
        this.selfBillingValueItem = selfBillingValueItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SDDocumentReason";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SDDocumentReason", getSDDocumentReason());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("RetroBillingUsage", getRetroBillingUsage());
        values.put("SelfBillingValueItem", getSelfBillingValueItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("RetroBillingUsage") ) {
                final Object value = values.remove("RetroBillingUsage");
                if( (value == null) || (!value.equals(getRetroBillingUsage())) ) {
                    setRetroBillingUsage(((String) value));
                }
            }
            if( values.containsKey("SelfBillingValueItem") ) {
                final Object value = values.remove("SelfBillingValueItem");
                if( (value == null) || (!value.equals(getSelfBillingValueItem())) ) {
                    setSelfBillingValueItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RetroBillingUsageText") ) {
                final Object value = (values).remove("to_RetroBillingUsageText");
                if( value instanceof Iterable ) {
                    if( toRetroBillingUsageText == null ) {
                        toRetroBillingUsageText = Lists.newArrayList();
                    } else {
                        toRetroBillingUsageText = Lists.newArrayList(toRetroBillingUsageText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RetroBillingUsageText entity;
                        if( toRetroBillingUsageText.size() > i ) {
                            entity = toRetroBillingUsageText.get(i);
                        } else {
                            entity = new RetroBillingUsageText();
                            toRetroBillingUsageText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SDDocumentReasonText") ) {
                final Object value = (values).remove("to_SDDocumentReasonText");
                if( value instanceof Iterable ) {
                    if( toSDDocumentReasonText == null ) {
                        toSDDocumentReasonText = Lists.newArrayList();
                    } else {
                        toSDDocumentReasonText = Lists.newArrayList(toSDDocumentReasonText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SDDocumentReasonText entity;
                        if( toSDDocumentReasonText.size() > i ) {
                            entity = toSDDocumentReasonText.get(i);
                        } else {
                            entity = new SDDocumentReasonText();
                            toSDDocumentReasonText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SelfBillingValueItemText") ) {
                final Object value = (values).remove("to_SelfBillingValueItemText");
                if( value instanceof Iterable ) {
                    if( toSelfBillingValueItemText == null ) {
                        toSelfBillingValueItemText = Lists.newArrayList();
                    } else {
                        toSelfBillingValueItemText = Lists.newArrayList(toSelfBillingValueItemText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SelfBillingValueItemText entity;
                        if( toSelfBillingValueItemText.size() > i ) {
                            entity = toSelfBillingValueItemText.get(i);
                        } else {
                            entity = new SelfBillingValueItemText();
                            toSelfBillingValueItemText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SDDocumentReasonField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SDDocumentReasonField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SDDocumentReasonField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SDDocumentReasonField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRetroBillingUsageText != null ) {
            (values).put("to_RetroBillingUsageText", toRetroBillingUsageText);
        }
        if( toSDDocumentReasonText != null ) {
            (values).put("to_SDDocumentReasonText", toSDDocumentReasonText);
        }
        if( toSelfBillingValueItemText != null ) {
            (values).put("to_SelfBillingValueItemText", toSelfBillingValueItemText);
        }
        return values;
    }

    /**
     * Fetches the <b>RetroBillingUsageText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RetroBillingUsageText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RetroBillingUsageText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RetroBillingUsageText> fetchRetroBillingUsageText()
    {
        return fetchFieldAsList("to_RetroBillingUsageText", RetroBillingUsageText.class);
    }

    /**
     * Retrieval of associated <b>RetroBillingUsageText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RetroBillingUsageText</b>.
     * <p>
     * If the navigation property <b>to_RetroBillingUsageText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RetroBillingUsageText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RetroBillingUsageText> getRetroBillingUsageTextOrFetch()
    {
        if( toRetroBillingUsageText == null ) {
            toRetroBillingUsageText = fetchRetroBillingUsageText();
        }
        return toRetroBillingUsageText;
    }

    /**
     * Retrieval of associated <b>RetroBillingUsageText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RetroBillingUsageText</b>.
     * <p>
     * If the navigation property for an entity <b>SDDocumentReason</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RetroBillingUsageText</b> is already loaded, the result
     *         will contain the <b>RetroBillingUsageText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RetroBillingUsageText>> getRetroBillingUsageTextIfPresent()
    {
        return Option.of(toRetroBillingUsageText);
    }

    /**
     * Overwrites the list of associated <b>RetroBillingUsageText</b> entities for the loaded navigation property
     * <b>to_RetroBillingUsageText</b>.
     * <p>
     * If the navigation property <b>to_RetroBillingUsageText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RetroBillingUsageText</b> entities.
     */
    public void setRetroBillingUsageText( @Nonnull final List<RetroBillingUsageText> value )
    {
        if( toRetroBillingUsageText == null ) {
            toRetroBillingUsageText = Lists.newArrayList();
        }
        toRetroBillingUsageText.clear();
        toRetroBillingUsageText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RetroBillingUsageText</b> entities. This corresponds to the OData
     * navigation property <b>to_RetroBillingUsageText</b>.
     * <p>
     * If the navigation property <b>to_RetroBillingUsageText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RetroBillingUsageText</b> entities.
     */
    public void addRetroBillingUsageText( RetroBillingUsageText... entity )
    {
        if( toRetroBillingUsageText == null ) {
            toRetroBillingUsageText = Lists.newArrayList();
        }
        toRetroBillingUsageText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SDDocumentReasonText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SDDocumentReasonText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SDDocumentReasonText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SDDocumentReasonText> fetchSDDocumentReasonText()
    {
        return fetchFieldAsList("to_SDDocumentReasonText", SDDocumentReasonText.class);
    }

    /**
     * Retrieval of associated <b>SDDocumentReasonText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SDDocumentReasonText</b>.
     * <p>
     * If the navigation property <b>to_SDDocumentReasonText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SDDocumentReasonText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SDDocumentReasonText> getSDDocumentReasonTextOrFetch()
    {
        if( toSDDocumentReasonText == null ) {
            toSDDocumentReasonText = fetchSDDocumentReasonText();
        }
        return toSDDocumentReasonText;
    }

    /**
     * Retrieval of associated <b>SDDocumentReasonText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SDDocumentReasonText</b>.
     * <p>
     * If the navigation property for an entity <b>SDDocumentReason</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SDDocumentReasonText</b> is already loaded, the result
     *         will contain the <b>SDDocumentReasonText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SDDocumentReasonText>> getSDDocumentReasonTextIfPresent()
    {
        return Option.of(toSDDocumentReasonText);
    }

    /**
     * Overwrites the list of associated <b>SDDocumentReasonText</b> entities for the loaded navigation property
     * <b>to_SDDocumentReasonText</b>.
     * <p>
     * If the navigation property <b>to_SDDocumentReasonText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SDDocumentReasonText</b> entities.
     */
    public void setSDDocumentReasonText( @Nonnull final List<SDDocumentReasonText> value )
    {
        if( toSDDocumentReasonText == null ) {
            toSDDocumentReasonText = Lists.newArrayList();
        }
        toSDDocumentReasonText.clear();
        toSDDocumentReasonText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SDDocumentReasonText</b> entities. This corresponds to the OData
     * navigation property <b>to_SDDocumentReasonText</b>.
     * <p>
     * If the navigation property <b>to_SDDocumentReasonText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SDDocumentReasonText</b> entities.
     */
    public void addSDDocumentReasonText( SDDocumentReasonText... entity )
    {
        if( toSDDocumentReasonText == null ) {
            toSDDocumentReasonText = Lists.newArrayList();
        }
        toSDDocumentReasonText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SelfBillingValueItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SelfBillingValueItemText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SelfBillingValueItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SelfBillingValueItemText> fetchSelfBillingValueItemText()
    {
        return fetchFieldAsList("to_SelfBillingValueItemText", SelfBillingValueItemText.class);
    }

    /**
     * Retrieval of associated <b>SelfBillingValueItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelfBillingValueItemText</b>.
     * <p>
     * If the navigation property <b>to_SelfBillingValueItemText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SelfBillingValueItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SelfBillingValueItemText> getSelfBillingValueItemTextOrFetch()
    {
        if( toSelfBillingValueItemText == null ) {
            toSelfBillingValueItemText = fetchSelfBillingValueItemText();
        }
        return toSelfBillingValueItemText;
    }

    /**
     * Retrieval of associated <b>SelfBillingValueItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SelfBillingValueItemText</b>.
     * <p>
     * If the navigation property for an entity <b>SDDocumentReason</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SelfBillingValueItemText</b> is already loaded, the
     *         result will contain the <b>SelfBillingValueItemText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SelfBillingValueItemText>> getSelfBillingValueItemTextIfPresent()
    {
        return Option.of(toSelfBillingValueItemText);
    }

    /**
     * Overwrites the list of associated <b>SelfBillingValueItemText</b> entities for the loaded navigation property
     * <b>to_SelfBillingValueItemText</b>.
     * <p>
     * If the navigation property <b>to_SelfBillingValueItemText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SelfBillingValueItemText</b> entities.
     */
    public void setSelfBillingValueItemText( @Nonnull final List<SelfBillingValueItemText> value )
    {
        if( toSelfBillingValueItemText == null ) {
            toSelfBillingValueItemText = Lists.newArrayList();
        }
        toSelfBillingValueItemText.clear();
        toSelfBillingValueItemText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SelfBillingValueItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_SelfBillingValueItemText</b>.
     * <p>
     * If the navigation property <b>to_SelfBillingValueItemText</b> of a queried <b>SDDocumentReason</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SelfBillingValueItemText</b> entities.
     */
    public void addSelfBillingValueItemText( SelfBillingValueItemText... entity )
    {
        if( toSelfBillingValueItemText == null ) {
            toSelfBillingValueItemText = Lists.newArrayList();
        }
        toSelfBillingValueItemText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SDDocumentReason instances.
     *
     */
    public final static class SDDocumentReasonBuilder
    {

        private List<RetroBillingUsageText> toRetroBillingUsageText = Lists.newArrayList();
        private List<SDDocumentReasonText> toSDDocumentReasonText = Lists.newArrayList();
        private List<SelfBillingValueItemText> toSelfBillingValueItemText = Lists.newArrayList();

        private SDDocumentReason.SDDocumentReasonBuilder toRetroBillingUsageText(
            final List<RetroBillingUsageText> value )
        {
            toRetroBillingUsageText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RetroBillingUsageText</b> for <b>SDDocumentReason</b> to multiple
         * <b>RetroBillingUsageText</b>.
         *
         * @param value
         *            The RetroBillingUsageTexts to build this SDDocumentReason with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SDDocumentReason.SDDocumentReasonBuilder retroBillingUsageText( RetroBillingUsageText... value )
        {
            return toRetroBillingUsageText(Lists.newArrayList(value));
        }

        private SDDocumentReason.SDDocumentReasonBuilder toSDDocumentReasonText(
            final List<SDDocumentReasonText> value )
        {
            toSDDocumentReasonText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SDDocumentReasonText</b> for <b>SDDocumentReason</b> to multiple
         * <b>SDDocumentReasonText</b>.
         *
         * @param value
         *            The SDDocumentReasonTexts to build this SDDocumentReason with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SDDocumentReason.SDDocumentReasonBuilder sdDocumentReasonText( SDDocumentReasonText... value )
        {
            return toSDDocumentReasonText(Lists.newArrayList(value));
        }

        private SDDocumentReason.SDDocumentReasonBuilder toSelfBillingValueItemText(
            final List<SelfBillingValueItemText> value )
        {
            toSelfBillingValueItemText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SelfBillingValueItemText</b> for <b>SDDocumentReason</b> to multiple
         * <b>SelfBillingValueItemText</b>.
         *
         * @param value
         *            The SelfBillingValueItemTexts to build this SDDocumentReason with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SDDocumentReason.SDDocumentReasonBuilder selfBillingValueItemText( SelfBillingValueItemText... value )
        {
            return toSelfBillingValueItemText(Lists.newArrayList(value));
        }

    }

}
