/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable.SDDocumentReasonSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason
 * SDDocumentReason} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SDDocumentReasonByKeyFluentHelper
    extends
    FluentHelperByKey<SDDocumentReasonByKeyFluentHelper, SDDocumentReason, SDDocumentReasonSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason
     * SDDocumentReason} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SDDocumentReason}
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SDDocumentReason}
     */
    public SDDocumentReasonByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sDDocumentReason )
    {
        super(servicePath, entityCollection);
        this.key.put("SDDocumentReason", sDDocumentReason);
    }

    @Override
    @Nonnull
    protected Class<SDDocumentReason> getEntityClass()
    {
        return SDDocumentReason.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
