/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.field.SelfBillingValueItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable.SelfBillingValueItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Description of Self-Billing Value Item Indicator
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SelfBillingValueItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SelfBillingValueItemText extends VdmEntity<SelfBillingValueItemText>
{

    /**
     * Selector for all available fields of SelfBillingValueItemText.
     *
     */
    public final static SelfBillingValueItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SelfBillingValueItem</b>
     * </p>
     *
     * @return Value Item for Self-Billing
     */
    @Key
    @SerializedName( "SelfBillingValueItem" )
    @JsonProperty( "SelfBillingValueItem" )
    @Nullable
    @ODataField( odataName = "SelfBillingValueItem" )
    private String selfBillingValueItem;
    /**
     * Use with available fluent helpers to apply the <b>SelfBillingValueItem</b> field to query operations.
     *
     */
    public final static SelfBillingValueItemTextField<String> SELF_BILLING_VALUE_ITEM =
        new SelfBillingValueItemTextField<String>("SelfBillingValueItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SelfBillingValueItemTextField<String> LANGUAGE =
        new SelfBillingValueItemTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SelfBillingValueItemDesc</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "SelfBillingValueItemDesc" )
    @JsonProperty( "SelfBillingValueItemDesc" )
    @Nullable
    @ODataField( odataName = "SelfBillingValueItemDesc" )
    private String selfBillingValueItemDesc;
    /**
     * Use with available fluent helpers to apply the <b>SelfBillingValueItemDesc</b> field to query operations.
     *
     */
    public final static SelfBillingValueItemTextField<String> SELF_BILLING_VALUE_ITEM_DESC =
        new SelfBillingValueItemTextField<String>("SelfBillingValueItemDesc");

    @Nonnull
    @Override
    public Class<SelfBillingValueItemText> getType()
    {
        return SelfBillingValueItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SelfBillingValueItem</b>
     * </p>
     *
     * @param selfBillingValueItem
     *            Value Item for Self-Billing
     */
    public void setSelfBillingValueItem( @Nullable final String selfBillingValueItem )
    {
        rememberChangedField("SelfBillingValueItem", this.selfBillingValueItem);
        this.selfBillingValueItem = selfBillingValueItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SelfBillingValueItemDesc</b>
     * </p>
     *
     * @param selfBillingValueItemDesc
     *            Short Text for Fixed Values
     */
    public void setSelfBillingValueItemDesc( @Nullable final String selfBillingValueItemDesc )
    {
        rememberChangedField("SelfBillingValueItemDesc", this.selfBillingValueItemDesc);
        this.selfBillingValueItemDesc = selfBillingValueItemDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SelfBillingValueItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SelfBillingValueItem", getSelfBillingValueItem());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SelfBillingValueItem", getSelfBillingValueItem());
        values.put("Language", getLanguage());
        values.put("SelfBillingValueItemDesc", getSelfBillingValueItemDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SelfBillingValueItem") ) {
                final Object value = values.remove("SelfBillingValueItem");
                if( (value == null) || (!value.equals(getSelfBillingValueItem())) ) {
                    setSelfBillingValueItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SelfBillingValueItemDesc") ) {
                final Object value = values.remove("SelfBillingValueItemDesc");
                if( (value == null) || (!value.equals(getSelfBillingValueItemDesc())) ) {
                    setSelfBillingValueItemDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SelfBillingValueItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SelfBillingValueItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SelfBillingValueItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SelfBillingValueItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService.DEFAULT_SERVICE_PATH);
    }

}
