/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable.SelfBillingValueItemTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText
 * SelfBillingValueItemText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SelfBillingValueItemTextByKeyFluentHelper
    extends
    FluentHelperByKey<SelfBillingValueItemTextByKeyFluentHelper, SelfBillingValueItemText, SelfBillingValueItemTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText
     * SelfBillingValueItemText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SelfBillingValueItemText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SelfBillingValueItemText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param selfBillingValueItem
     *            Value Item for Self-Billing
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public SelfBillingValueItemTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String selfBillingValueItem,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("SelfBillingValueItem", selfBillingValueItem);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<SelfBillingValueItemText> getEntityClass()
    {
        return SelfBillingValueItemText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
