/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesAndDistributionDocumentOrderReasonServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService
 * SalesAndDistributionDocumentOrderReasonService}, allowing you to create multiple changesets and finally execute the
 * batch request.
 *
 */
public class DefaultSalesAndDistributionDocumentOrderReasonServiceBatch
    extends
    BatchFluentHelperBasic<SalesAndDistributionDocumentOrderReasonServiceBatch, SalesAndDistributionDocumentOrderReasonServiceBatchChangeSet>
    implements
    SalesAndDistributionDocumentOrderReasonServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesAndDistributionDocumentOrderReasonServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesAndDistributionDocumentOrderReasonServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesAndDistributionDocumentOrderReasonServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesAndDistributionDocumentOrderReasonServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesAndDistributionDocumentOrderReasonServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesAndDistributionDocumentOrderReasonServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesAndDistributionDocumentOrderReasonServiceBatchChangeSet(this, service);
    }

}
