/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SalesAndDistributionDocumentOrderReasonServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService
 * SalesAndDistributionDocumentOrderReasonService}.
 *
 */
public class DefaultSalesAndDistributionDocumentOrderReasonServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesAndDistributionDocumentOrderReasonServiceBatch, SalesAndDistributionDocumentOrderReasonServiceBatchChangeSet>
    implements
    SalesAndDistributionDocumentOrderReasonServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesAndDistributionDocumentOrderReasonServiceBatchChangeSet(
        @Nonnull final DefaultSalesAndDistributionDocumentOrderReasonServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesAndDistributionDocumentOrderReasonService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesAndDistributionDocumentOrderReasonServiceBatchChangeSet getThis()
    {
        return this;
    }

}
