/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason
 * SDDocumentReason}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.field.SDDocumentReasonField
 * SDDocumentReasonField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.link.SDDocumentReasonLink
 * SDDocumentReasonLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason#SD_DOCUMENT_REASON
 * SD_DOCUMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason#RETRO_BILLING_USAGE
 * RETRO_BILLING_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason#SELF_BILLING_VALUE_ITEM
 * SELF_BILLING_VALUE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason#TO_RETRO_BILLING_USAGE_TEXT
 * TO_RETRO_BILLING_USAGE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason#TO_SD_DOCUMENT_REASON_TEXT
 * TO_SD_DOCUMENT_REASON_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReason#TO_SELF_BILLING_VALUE_ITEM_TEXT
 * TO_SELF_BILLING_VALUE_ITEM_TEXT}</li>
 * </ul>
 *
 */
public interface SDDocumentReasonSelectable extends EntitySelectable<SDDocumentReason>
{

}
