/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonText
 * SDDocumentReasonText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.field.SDDocumentReasonTextField
 * SDDocumentReasonTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.link.SDDocumentReasonTextLink
 * SDDocumentReasonTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonText#SD_DOCUMENT_REASON
 * SD_DOCUMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SDDocumentReasonText#SD_DOCUMENT_REASON_TEXT
 * SD_DOCUMENT_REASON_TEXT}</li>
 * </ul>
 *
 */
public interface SDDocumentReasonTextSelectable extends EntitySelectable<SDDocumentReasonText>
{

}
