/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText
 * SelfBillingValueItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.field.SelfBillingValueItemTextField
 * SelfBillingValueItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.link.SelfBillingValueItemTextLink
 * SelfBillingValueItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText#SELF_BILLING_VALUE_ITEM
 * SELF_BILLING_VALUE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesanddistributiondocumentorderreason.SelfBillingValueItemText#SELF_BILLING_VALUE_ITEM_DESC
 * SELF_BILLING_VALUE_ITEM_DESC}</li>
 * </ul>
 *
 */
public interface SelfBillingValueItemTextSelectable extends EntitySelectable<SelfBillingValueItemText>
{

}
