/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.selectable.SalesContractItemPrcgElmntSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
 * SalesContractItemPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SalesContractItemPrcgElmntByKeyFluentHelper
    extends
    FluentHelperByKey<SalesContractItemPrcgElmntByKeyFluentHelper, SalesContractItemPrcgElmnt, SalesContractItemPrcgElmntSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param salesContractItem
     *            Sales Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesContractItemPrcgElmnt}
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesContractItemPrcgElmnt}
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public SalesContractItemPrcgElmntByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesContract,
        final String salesContractItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesContract", salesContract);
        this.key.put("SalesContractItem", salesContractItem);
        this.key.put("PricingProcedureStep", pricingProcedureStep);
        this.key.put("PricingProcedureCounter", pricingProcedureCounter);
    }

    @Override
    @Nonnull
    protected Class<SalesContractItemPrcgElmnt> getEntityClass()
    {
        return SalesContractItemPrcgElmnt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
