/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText SalesContractItemText}
 * entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class SalesContractItemTextUpdateFluentHelper
    extends
    FluentHelperUpdate<SalesContractItemTextUpdateFluentHelper, SalesContractItemText>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity object that will be updated in the S/4HANA system.
     *
     */
    private final SalesContractItemText entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The SalesContractItemText to take the updated values from.
     */
    public SalesContractItemTextUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final SalesContractItemText entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected SalesContractItemText getEntity()
    {
        return entity;
    }

}
