/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.field.SalesContractTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.link.SalesContractTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.selectable.SalesContractTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesContractTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesContractText extends VdmEntity<SalesContractText>
{

    /**
     * Selector for all available fields of SalesContractText.
     *
     */
    public final static SalesContractTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesContract</b>
     * </p>
     *
     * @return Sales Contract
     */
    @Key
    @SerializedName( "SalesContract" )
    @JsonProperty( "SalesContract" )
    @Nullable
    @ODataField( odataName = "SalesContract" )
    private String salesContract;
    /**
     * Use with available fluent helpers to apply the <b>SalesContract</b> field to query operations.
     *
     */
    public final static SalesContractTextField<String> SALES_CONTRACT =
        new SalesContractTextField<String>("SalesContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SalesContractTextField<String> LANGUAGE = new SalesContractTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static SalesContractTextField<String> LONG_TEXT_ID = new SalesContractTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static SalesContractTextField<String> LONG_TEXT = new SalesContractTextField<String>("LongText");
    /**
     * Navigation property <b>to_SalesContract</b> for <b>SalesContractText</b> to single <b>SalesContract</b>.
     *
     */
    @SerializedName( "to_SalesContract" )
    @JsonProperty( "to_SalesContract" )
    @ODataField( odataName = "to_SalesContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesContract toSalesContract;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesContract</b> navigation property to query operations.
     *
     */
    public final static SalesContractTextOneToOneLink<SalesContract> TO_SALES_CONTRACT =
        new SalesContractTextOneToOneLink<SalesContract>("to_SalesContract");

    @Nonnull
    @Override
    public Class<SalesContractText> getType()
    {
        return SalesContractText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesContract</b>
     * </p>
     *
     * @param salesContract
     *            Sales Contract
     */
    public void setSalesContract( @Nullable final String salesContract )
    {
        rememberChangedField("SalesContract", this.salesContract);
        this.salesContract = salesContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesContractText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesContract", getSalesContract());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesContract", getSalesContract());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesContract") ) {
                final Object value = values.remove("SalesContract");
                if( (value == null) || (!value.equals(getSalesContract())) ) {
                    setSalesContract(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesContract") ) {
                final Object value = (values).remove("to_SalesContract");
                if( value instanceof Map ) {
                    if( toSalesContract == null ) {
                        toSalesContract = new SalesContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesContractTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesContractTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesContractTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesContractTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesContract != null ) {
            (values).put("to_SalesContract", toSalesContract);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesContract</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesContract</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesContract fetchSalesContract()
    {
        return fetchFieldAsSingle("to_SalesContract", SalesContract.class);
    }

    /**
     * Retrieval of associated <b>SalesContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesContract</b>.
     * <p>
     * If the navigation property <b>to_SalesContract</b> of a queried <b>SalesContractText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesContract getSalesContractOrFetch()
    {
        if( toSalesContract == null ) {
            toSalesContract = fetchSalesContract();
        }
        return toSalesContract;
    }

    /**
     * Retrieval of associated <b>SalesContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesContract</b>.
     * <p>
     * If the navigation property for an entity <b>SalesContractText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesContract</b> is already loaded, the result will
     *         contain the <b>SalesContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesContract> getSalesContractIfPresent()
    {
        return Option.of(toSalesContract);
    }

    /**
     * Overwrites the associated <b>SalesContract</b> entity for the loaded navigation property <b>to_SalesContract</b>.
     *
     * @param value
     *            New <b>SalesContract</b> entity.
     */
    public void setSalesContract( final SalesContract value )
    {
        toSalesContract = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesContractText instances.
     *
     */
    public final static class SalesContractTextBuilder
    {

        private SalesContract toSalesContract;
        private String salesContract = null;

        private SalesContractText.SalesContractTextBuilder toSalesContract( final SalesContract value )
        {
            toSalesContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesContract</b> for <b>SalesContractText</b> to single <b>SalesContract</b>.
         *
         * @param value
         *            The SalesContract to build this SalesContractText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesContractText.SalesContractTextBuilder salesContract( final SalesContract value )
        {
            return toSalesContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesContract</b>
         * </p>
         *
         * @param value
         *            The salesContract to build this SalesContractText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesContractText.SalesContractTextBuilder salesContract( final String value )
        {
            salesContract = value;
            return this;
        }

    }

}
