/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesContractServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService SalesContractService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesContractServiceBatch
    extends
    BatchFluentHelperBasic<SalesContractServiceBatch, SalesContractServiceBatchChangeSet>
    implements
    SalesContractServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesContractServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesContractServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesContractServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesContractServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesContractServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesContractServiceBatchChangeSet(this, service);
    }

}
