/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText;

/**
 * Implementation of the {@link SalesContractServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService SalesContractService}.
 *
 */
public class DefaultSalesContractServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesContractServiceBatch, SalesContractServiceBatchChangeSet>
    implements
    SalesContractServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesContractServiceBatchChangeSet(
        @Nonnull final DefaultSalesContractServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesContractServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet createSalesContract( @Nonnull final SalesContract salesContract )
    {
        return addRequestCreate(service::createSalesContract, salesContract);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContract( @Nonnull final SalesContract salesContract )
    {
        return addRequestUpdate(service::updateSalesContract, salesContract);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContract( @Nonnull final SalesContract salesContract )
    {
        return addRequestDelete(service::deleteSalesContract, salesContract);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet createSalesContractItem(
        @Nonnull final SalesContractItem salesContractItem )
    {
        return addRequestCreate(service::createSalesContractItem, salesContractItem);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractItem(
        @Nonnull final SalesContractItem salesContractItem )
    {
        return addRequestUpdate(service::updateSalesContractItem, salesContractItem);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractItem(
        @Nonnull final SalesContractItem salesContractItem )
    {
        return addRequestDelete(service::deleteSalesContractItem, salesContractItem);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractItemPartner(
        @Nonnull final SalesContractItemPartner salesContractItemPartner )
    {
        return addRequestUpdate(service::updateSalesContractItemPartner, salesContractItemPartner);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractItemPartner(
        @Nonnull final SalesContractItemPartner salesContractItemPartner )
    {
        return addRequestDelete(service::deleteSalesContractItemPartner, salesContractItemPartner);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractItemPrcgElmnt(
        @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt )
    {
        return addRequestUpdate(service::updateSalesContractItemPrcgElmnt, salesContractItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractItemPrcgElmnt(
        @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt )
    {
        return addRequestDelete(service::deleteSalesContractItemPrcgElmnt, salesContractItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractItemText(
        @Nonnull final SalesContractItemText salesContractItemText )
    {
        return addRequestUpdate(service::updateSalesContractItemText, salesContractItemText);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractItemText(
        @Nonnull final SalesContractItemText salesContractItemText )
    {
        return addRequestDelete(service::deleteSalesContractItemText, salesContractItemText);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet createSalesContractPartner(
        @Nonnull final SalesContractPartner salesContractPartner )
    {
        return addRequestCreate(service::createSalesContractPartner, salesContractPartner);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractPartner(
        @Nonnull final SalesContractPartner salesContractPartner )
    {
        return addRequestUpdate(service::updateSalesContractPartner, salesContractPartner);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractPartner(
        @Nonnull final SalesContractPartner salesContractPartner )
    {
        return addRequestDelete(service::deleteSalesContractPartner, salesContractPartner);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractPrcgElmnt(
        @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt )
    {
        return addRequestUpdate(service::updateSalesContractPrcgElmnt, salesContractPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractPrcgElmnt(
        @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt )
    {
        return addRequestDelete(service::deleteSalesContractPrcgElmnt, salesContractPrcgElmnt);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet updateSalesContractText(
        @Nonnull final SalesContractText salesContractText )
    {
        return addRequestUpdate(service::updateSalesContractText, salesContractText);
    }

    @Nonnull
    @Override
    public SalesContractServiceBatchChangeSet deleteSalesContractText(
        @Nonnull final SalesContractText salesContractText )
    {
        return addRequestDelete(service::deleteSalesContractText, salesContractText);
    }

}
