/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesContractService SalesContractService}.
 *
 */
public interface SalesContractServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SalesContractServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SalesContractServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity and save it to the S/4HANA system.
     *
     * @param salesContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet createSalesContract( @Nonnull final SalesContract salesContract );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity and save it to the S/4HANA system.
     *
     * @param salesContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet updateSalesContract( @Nonnull final SalesContract salesContract );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity in the S/4HANA system.
     *
     * @param salesContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet deleteSalesContract( @Nonnull final SalesContract salesContract );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity and save it to the S/4HANA system.
     *
     * @param salesContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *            SalesContractItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet createSalesContractItem( @Nonnull final SalesContractItem salesContractItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity and save it to the S/4HANA system.
     *
     * @param salesContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *            SalesContractItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet updateSalesContractItem( @Nonnull final SalesContractItem salesContractItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity in the S/4HANA system.
     *
     * @param salesContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *            SalesContractItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet deleteSalesContractItem( @Nonnull final SalesContractItem salesContractItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     * SalesContractItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesContractItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *            SalesContractItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        updateSalesContractItemPartner( @Nonnull final SalesContractItemPartner salesContractItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     * SalesContractItemPartner} entity in the S/4HANA system.
     *
     * @param salesContractItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *            SalesContractItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        deleteSalesContractItemPartner( @Nonnull final SalesContractItemPartner salesContractItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesContractItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *            SalesContractItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        updateSalesContractItemPrcgElmnt( @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesContractItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *            SalesContractItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        deleteSalesContractItemPrcgElmnt( @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity and save it to the S/4HANA system.
     *
     * @param salesContractItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *            SalesContractItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        updateSalesContractItemText( @Nonnull final SalesContractItemText salesContractItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity in the S/4HANA system.
     *
     * @param salesContractItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *            SalesContractItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        deleteSalesContractItemText( @Nonnull final SalesContractItemText salesContractItemText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity and save it to the S/4HANA system.
     *
     * @param salesContractPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *            SalesContractPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        createSalesContractPartner( @Nonnull final SalesContractPartner salesContractPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity and save it to the S/4HANA system.
     *
     * @param salesContractPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *            SalesContractPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        updateSalesContractPartner( @Nonnull final SalesContractPartner salesContractPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity in the S/4HANA system.
     *
     * @param salesContractPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *            SalesContractPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        deleteSalesContractPartner( @Nonnull final SalesContractPartner salesContractPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     * SalesContractPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesContractPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *            SalesContractPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        updateSalesContractPrcgElmnt( @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     * SalesContractPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesContractPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *            SalesContractPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet
        deleteSalesContractPrcgElmnt( @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     * SalesContractText} entity and save it to the S/4HANA system.
     *
     * @param salesContractText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *            SalesContractText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet updateSalesContractText( @Nonnull final SalesContractText salesContractText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     * SalesContractText} entity in the S/4HANA system.
     *
     * @param salesContractText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *            SalesContractText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesContractServiceBatchChangeSet deleteSalesContractText( @Nonnull final SalesContractText salesContractText );

}
