/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem SalesContractItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.field.SalesContractItemField
 * SalesContractItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.link.SalesContractItemLink
 * SalesContractItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT
 * SALES_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_ITEM
 * SALES_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_ITEM_CATEGORY
 * SALES_CONTRACT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_ITEM_TEXT
 * SALES_CONTRACT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#REQUESTED_QUANTITY_UNIT
 * REQUESTED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#REQUESTED_QUANTITY_SAP_UNIT
 * REQUESTED_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#REQUESTED_QUANTITY_ISO_UNIT
 * REQUESTED_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_WEIGHT_SAP_UNIT
 * ITEM_WEIGHT_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_WEIGHT_ISO_UNIT
 * ITEM_WEIGHT_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_VOLUME_SAP_UNIT
 * ITEM_VOLUME_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_VOLUME_ISO_UNIT
 * ITEM_VOLUME_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#OUTLINE_AGREEMENT_TARGET_AMOUNT
 * OUTLINE_AGREEMENT_TARGET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#MATERIAL_PRICING_GROUP
 * MATERIAL_PRICING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#ITEM_BILLING_BLOCK_REASON
 * ITEM_BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#REFERENCE_SD_DOCUMENT_ITEM
 * REFERENCE_SD_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_VALIDITY_START_DATE
 * SALES_CONTRACT_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_VALIDITY_END_DATE
 * SALES_CONTRACT_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#NMBR_OF_SALES_CONTRACT_VALDTY_PERD
 * NMBR_OF_SALES_CONTRACT_VALDTY_PERD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_VALIDITY_PERD_UNIT
 * SALES_CONTRACT_VALIDITY_PERD_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_VALIDITY_PERD_CAT
 * SALES_CONTRACT_VALIDITY_PERD_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_SIGNED_DATE
 * SALES_CONTRACT_SIGNED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SALES_CONTRACT_FOLLOW_UP_ACTION
 * SALES_CONTRACT_FOLLOW_UP_ACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SLS_CONTRACT_FOLLOW_UP_ACTION_DATE
 * SLS_CONTRACT_FOLLOW_UP_ACTION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SLS_CONTR_ITEM_RELEASED_QUANTITY
 * SLS_CONTR_ITEM_RELEASED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#SLS_CONTR_ITM_RELD_QUANTITY_UNIT
 * SLS_CONTR_ITM_RELD_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#TO_SALES_CONTRACT
 * TO_SALES_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface SalesContractItemSelectable extends EntitySelectable<SalesContractItem>
{

}
