/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
 * SalesContractItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.field.SalesContractItemTextField
 * SalesContractItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.link.SalesContractItemTextLink
 * SalesContractItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#SALES_CONTRACT
 * SALES_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#SALES_CONTRACT_ITEM
 * SALES_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#TO_SALES_CONTRACT
 * TO_SALES_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText#TO_SALES_CONTRACT_ITEM
 * TO_SALES_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface SalesContractItemTextSelectable extends EntitySelectable<SalesContractItemText>
{

}
