/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.field.SalesDistrictTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.link.SalesDistrictTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.selectable.SalesDistrictTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales District Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesDistrictTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesDistrictText extends VdmEntity<SalesDistrictText>
{

    /**
     * Selector for all available fields of SalesDistrictText.
     *
     */
    public final static SalesDistrictTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @Key
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static SalesDistrictTextField<String> SALES_DISTRICT =
        new SalesDistrictTextField<String>("SalesDistrict");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SalesDistrictTextField<String> LANGUAGE = new SalesDistrictTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrictName</b>
     * </p>
     *
     * @return Name of the District
     */
    @SerializedName( "SalesDistrictName" )
    @JsonProperty( "SalesDistrictName" )
    @Nullable
    @ODataField( odataName = "SalesDistrictName" )
    private String salesDistrictName;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrictName</b> field to query operations.
     *
     */
    public final static SalesDistrictTextField<String> SALES_DISTRICT_NAME =
        new SalesDistrictTextField<String>("SalesDistrictName");
    /**
     * Navigation property <b>to_SalesDistrict</b> for <b>SalesDistrictText</b> to single <b>SalesDistrict</b>.
     *
     */
    @SerializedName( "to_SalesDistrict" )
    @JsonProperty( "to_SalesDistrict" )
    @ODataField( odataName = "to_SalesDistrict" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesDistrict toSalesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesDistrict</b> navigation property to query operations.
     *
     */
    public final static SalesDistrictTextOneToOneLink<SalesDistrict> TO_SALES_DISTRICT =
        new SalesDistrictTextOneToOneLink<SalesDistrict>("to_SalesDistrict");

    @Nonnull
    @Override
    public Class<SalesDistrictText> getType()
    {
        return SalesDistrictText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrictName</b>
     * </p>
     *
     * @param salesDistrictName
     *            Name of the District
     */
    public void setSalesDistrictName( @Nullable final String salesDistrictName )
    {
        rememberChangedField("SalesDistrictName", this.salesDistrictName);
        this.salesDistrictName = salesDistrictName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesDistrictText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesDistrict", getSalesDistrict());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesDistrict", getSalesDistrict());
        values.put("Language", getLanguage());
        values.put("SalesDistrictName", getSalesDistrictName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SalesDistrictName") ) {
                final Object value = values.remove("SalesDistrictName");
                if( (value == null) || (!value.equals(getSalesDistrictName())) ) {
                    setSalesDistrictName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesDistrict") ) {
                final Object value = (values).remove("to_SalesDistrict");
                if( value instanceof Map ) {
                    if( toSalesDistrict == null ) {
                        toSalesDistrict = new SalesDistrict();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesDistrict.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesDistrictTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesDistrictTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesDistrictTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesDistrictTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesDistrict != null ) {
            (values).put("to_SalesDistrict", toSalesDistrict);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesDistrict</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesDistrict</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesDistrict</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesDistrict fetchSalesDistrict()
    {
        return fetchFieldAsSingle("to_SalesDistrict", SalesDistrict.class);
    }

    /**
     * Retrieval of associated <b>SalesDistrict</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesDistrict</b>.
     * <p>
     * If the navigation property <b>to_SalesDistrict</b> of a queried <b>SalesDistrictText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesDistrict</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesDistrict getSalesDistrictOrFetch()
    {
        if( toSalesDistrict == null ) {
            toSalesDistrict = fetchSalesDistrict();
        }
        return toSalesDistrict;
    }

    /**
     * Retrieval of associated <b>SalesDistrict</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesDistrict</b>.
     * <p>
     * If the navigation property for an entity <b>SalesDistrictText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesDistrict</b> is already loaded, the result will
     *         contain the <b>SalesDistrict</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesDistrict> getSalesDistrictIfPresent()
    {
        return Option.of(toSalesDistrict);
    }

    /**
     * Overwrites the associated <b>SalesDistrict</b> entity for the loaded navigation property <b>to_SalesDistrict</b>.
     *
     * @param value
     *            New <b>SalesDistrict</b> entity.
     */
    public void setSalesDistrict( final SalesDistrict value )
    {
        toSalesDistrict = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesDistrictText instances.
     *
     */
    public final static class SalesDistrictTextBuilder
    {

        private SalesDistrict toSalesDistrict;
        private String salesDistrict = null;

        private SalesDistrictText.SalesDistrictTextBuilder toSalesDistrict( final SalesDistrict value )
        {
            toSalesDistrict = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesDistrict</b> for <b>SalesDistrictText</b> to single <b>SalesDistrict</b>.
         *
         * @param value
         *            The SalesDistrict to build this SalesDistrictText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesDistrictText.SalesDistrictTextBuilder salesDistrict( final SalesDistrict value )
        {
            return toSalesDistrict(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesDistrict</b>
         * </p>
         *
         * @param value
         *            The salesDistrict to build this SalesDistrictText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesDistrictText.SalesDistrictTextBuilder salesDistrict( final String value )
        {
            salesDistrict = value;
            return this;
        }

    }

}
