/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesDistrictServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService SalesDistrictService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesDistrictServiceBatch
    extends
    BatchFluentHelperBasic<SalesDistrictServiceBatch, SalesDistrictServiceBatchChangeSet>
    implements
    SalesDistrictServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesDistrictServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesDistrictServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesDistrictServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesDistrictServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesDistrictServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesDistrictServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesDistrictServiceBatchChangeSet(this, service);
    }

}
