/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SalesDistrictServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService SalesDistrictService}.
 *
 */
public class DefaultSalesDistrictServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesDistrictServiceBatch, SalesDistrictServiceBatchChangeSet>
    implements
    SalesDistrictServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesDistrictServiceBatchChangeSet(
        @Nonnull final DefaultSalesDistrictServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDistrictService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesDistrictServiceBatchChangeSet getThis()
    {
        return this;
    }

}
