/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrict;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrict SalesDistrict}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.field.SalesDistrictField
 * SalesDistrictField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.link.SalesDistrictLink SalesDistrictLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrict#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrict#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface SalesDistrictSelectable extends EntitySelectable<SalesDistrict>
{

}
