/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictText SalesDistrictText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.field.SalesDistrictTextField
 * SalesDistrictTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.link.SalesDistrictTextLink
 * SalesDistrictTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictText#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictText#SALES_DISTRICT_NAME
 * SALES_DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdistrict.SalesDistrictText#TO_SALES_DISTRICT
 * TO_SALES_DISTRICT}</li>
 * </ul>
 *
 */
public interface SalesDistrictTextSelectable extends EntitySelectable<SalesDistrictText>
{

}
