/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.field.CreditBlockedSalesDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.selectable.CreditBlockedSalesDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Credit Blocked Sales Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CreditBlockedSalesDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditBlockedSalesDocument extends VdmEntity<CreditBlockedSalesDocument>
{

    /**
     * Selector for all available fields of CreditBlockedSalesDocument.
     *
     */
    public final static CreditBlockedSalesDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SALES_DOCUMENT =
        new CreditBlockedSalesDocumentField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @return SD Document Category
     */
    @SerializedName( "SDDocumentCategory" )
    @JsonProperty( "SDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SDDocumentCategory" )
    private String sDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentCategory</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SD_DOCUMENT_CATEGORY =
        new CreditBlockedSalesDocumentField<String>("SDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentType</b>
     * </p>
     *
     * @return Sales Document Type
     */
    @SerializedName( "SalesDocumentType" )
    @JsonProperty( "SalesDocumentType" )
    @Nullable
    @ODataField( odataName = "SalesDocumentType" )
    private String salesDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentType</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SALES_DOCUMENT_TYPE =
        new CreditBlockedSalesDocumentField<String>("SalesDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SALES_ORGANIZATION =
        new CreditBlockedSalesDocumentField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> DISTRIBUTION_CHANNEL =
        new CreditBlockedSalesDocumentField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> ORGANIZATION_DIVISION =
        new CreditBlockedSalesDocumentField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SALES_OFFICE =
        new CreditBlockedSalesDocumentField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SALES_GROUP =
        new CreditBlockedSalesDocumentField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> CREATED_BY_USER =
        new CreditBlockedSalesDocumentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<LocalDateTime> CREATION_DATE =
        new CreditBlockedSalesDocumentField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return User Who Last Changed the Business Document
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> LAST_CHANGED_BY_USER =
        new CreditBlockedSalesDocumentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<LocalDateTime> LAST_CHANGE_DATE =
        new CreditBlockedSalesDocumentField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> SOLD_TO_PARTY =
        new CreditBlockedSalesDocumentField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value of the Sales Order in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<BigDecimal> TOTAL_NET_AMOUNT =
        new CreditBlockedSalesDocumentField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> TRANSACTION_CURRENCY =
        new CreditBlockedSalesDocumentField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCreditAccount</b>
     * </p>
     *
     * @return Customer's account number with credit limit reference
     */
    @SerializedName( "CustomerCreditAccount" )
    @JsonProperty( "CustomerCreditAccount" )
    @Nullable
    @ODataField( odataName = "CustomerCreditAccount" )
    private String customerCreditAccount;
    /**
     * Use with available fluent helpers to apply the <b>CustomerCreditAccount</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> CUSTOMER_CREDIT_ACCOUNT =
        new CreditBlockedSalesDocumentField<String>("CustomerCreditAccount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrency</b>
     * </p>
     *
     * @return Currency key of credit control area
     */
    @SerializedName( "ControllingAreaCurrency" )
    @JsonProperty( "ControllingAreaCurrency" )
    @Nullable
    @ODataField( odataName = "ControllingAreaCurrency" )
    private String controllingAreaCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaCurrency</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> CONTROLLING_AREA_CURRENCY =
        new CreditBlockedSalesDocumentField<String>("ControllingAreaCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedCreditAmount</b>
     * </p>
     *
     * @return Released Credit Value of the Document
     */
    @SerializedName( "ReleasedCreditAmount" )
    @JsonProperty( "ReleasedCreditAmount" )
    @Nullable
    @ODataField( odataName = "ReleasedCreditAmount" )
    private BigDecimal releasedCreditAmount;
    /**
     * Use with available fluent helpers to apply the <b>ReleasedCreditAmount</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<BigDecimal> RELEASED_CREDIT_AMOUNT =
        new CreditBlockedSalesDocumentField<BigDecimal>("ReleasedCreditAmount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditBlockReleaseDate</b>
     * </p>
     *
     * @return Release date of the document determined by credit management
     */
    @SerializedName( "CreditBlockReleaseDate" )
    @JsonProperty( "CreditBlockReleaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditBlockReleaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditBlockReleaseDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditBlockReleaseDate</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<LocalDateTime> CREDIT_BLOCK_RELEASE_DATE =
        new CreditBlockedSalesDocumentField<LocalDateTime>("CreditBlockReleaseDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextShippingDate</b>
     * </p>
     *
     * @return Next date
     */
    @SerializedName( "NextShippingDate" )
    @JsonProperty( "NextShippingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NextShippingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime nextShippingDate;
    /**
     * Use with available fluent helpers to apply the <b>NextShippingDate</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<LocalDateTime> NEXT_SHIPPING_DATE =
        new CreditBlockedSalesDocumentField<LocalDateTime>("NextShippingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextCreditCheckDate</b>
     * </p>
     *
     * @return Date of Next Credit Check of Document
     */
    @SerializedName( "NextCreditCheckDate" )
    @JsonProperty( "NextCreditCheckDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NextCreditCheckDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime nextCreditCheckDate;
    /**
     * Use with available fluent helpers to apply the <b>NextCreditCheckDate</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<LocalDateTime> NEXT_CREDIT_CHECK_DATE =
        new CreditBlockedSalesDocumentField<LocalDateTime>("NextCreditCheckDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinDocCreditCheckStatus</b>
     * </p>
     *
     * @return Status of Credit Check Against Financial Document
     */
    @SerializedName( "FinDocCreditCheckStatus" )
    @JsonProperty( "FinDocCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "FinDocCreditCheckStatus" )
    private String finDocCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>FinDocCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> FIN_DOC_CREDIT_CHECK_STATUS =
        new CreditBlockedSalesDocumentField<String>("FinDocCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @return Overall Status of Credit Checks
     */
    @SerializedName( "TotalCreditCheckStatus" )
    @JsonProperty( "TotalCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "TotalCreditCheckStatus" )
    private String totalCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> TOTAL_CREDIT_CHECK_STATUS =
        new CreditBlockedSalesDocumentField<String>("TotalCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> OVERALL_SD_PROCESS_STATUS =
        new CreditBlockedSalesDocumentField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditCheckStatus</b>
     * </p>
     *
     * @return Status of Credit Check SAP Credit Management
     */
    @SerializedName( "CentralCreditCheckStatus" )
    @JsonProperty( "CentralCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "CentralCreditCheckStatus" )
    private String centralCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>CentralCreditCheckStatus</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> CENTRAL_CREDIT_CHECK_STATUS =
        new CreditBlockedSalesDocumentField<String>("CentralCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditChkTechErrSts</b>
     * </p>
     *
     * @return Status of Technical Error SAP Credit Management
     */
    @SerializedName( "CentralCreditChkTechErrSts" )
    @JsonProperty( "CentralCreditChkTechErrSts" )
    @Nullable
    @ODataField( odataName = "CentralCreditChkTechErrSts" )
    private String centralCreditChkTechErrSts;
    /**
     * Use with available fluent helpers to apply the <b>CentralCreditChkTechErrSts</b> field to query operations.
     *
     */
    public final static CreditBlockedSalesDocumentField<String> CENTRAL_CREDIT_CHK_TECH_ERR_STS =
        new CreditBlockedSalesDocumentField<String>("CentralCreditChkTechErrSts");

    @Nonnull
    @Override
    public Class<CreditBlockedSalesDocument> getType()
    {
        return CreditBlockedSalesDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentCategory</b>
     * </p>
     *
     * @param sDDocumentCategory
     *            SD Document Category
     */
    public void setSDDocumentCategory( @Nullable final String sDDocumentCategory )
    {
        rememberChangedField("SDDocumentCategory", this.sDDocumentCategory);
        this.sDDocumentCategory = sDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentType</b>
     * </p>
     *
     * @param salesDocumentType
     *            Sales Document Type
     */
    public void setSalesDocumentType( @Nullable final String salesDocumentType )
    {
        rememberChangedField("SalesDocumentType", this.salesDocumentType);
        this.salesDocumentType = salesDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            User Who Last Changed the Business Document
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value of the Sales Order in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCreditAccount</b>
     * </p>
     *
     * @param customerCreditAccount
     *            Customer's account number with credit limit reference
     */
    public void setCustomerCreditAccount( @Nullable final String customerCreditAccount )
    {
        rememberChangedField("CustomerCreditAccount", this.customerCreditAccount);
        this.customerCreditAccount = customerCreditAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaCurrency</b>
     * </p>
     *
     * @param controllingAreaCurrency
     *            Currency key of credit control area
     */
    public void setControllingAreaCurrency( @Nullable final String controllingAreaCurrency )
    {
        rememberChangedField("ControllingAreaCurrency", this.controllingAreaCurrency);
        this.controllingAreaCurrency = controllingAreaCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedCreditAmount</b>
     * </p>
     *
     * @param releasedCreditAmount
     *            Released Credit Value of the Document
     */
    public void setReleasedCreditAmount( @Nullable final BigDecimal releasedCreditAmount )
    {
        rememberChangedField("ReleasedCreditAmount", this.releasedCreditAmount);
        this.releasedCreditAmount = releasedCreditAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditBlockReleaseDate</b>
     * </p>
     *
     * @param creditBlockReleaseDate
     *            Release date of the document determined by credit management
     */
    public void setCreditBlockReleaseDate( @Nullable final LocalDateTime creditBlockReleaseDate )
    {
        rememberChangedField("CreditBlockReleaseDate", this.creditBlockReleaseDate);
        this.creditBlockReleaseDate = creditBlockReleaseDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextShippingDate</b>
     * </p>
     *
     * @param nextShippingDate
     *            Next date
     */
    public void setNextShippingDate( @Nullable final LocalDateTime nextShippingDate )
    {
        rememberChangedField("NextShippingDate", this.nextShippingDate);
        this.nextShippingDate = nextShippingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NextCreditCheckDate</b>
     * </p>
     *
     * @param nextCreditCheckDate
     *            Date of Next Credit Check of Document
     */
    public void setNextCreditCheckDate( @Nullable final LocalDateTime nextCreditCheckDate )
    {
        rememberChangedField("NextCreditCheckDate", this.nextCreditCheckDate);
        this.nextCreditCheckDate = nextCreditCheckDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinDocCreditCheckStatus</b>
     * </p>
     *
     * @param finDocCreditCheckStatus
     *            Status of Credit Check Against Financial Document
     */
    public void setFinDocCreditCheckStatus( @Nullable final String finDocCreditCheckStatus )
    {
        rememberChangedField("FinDocCreditCheckStatus", this.finDocCreditCheckStatus);
        this.finDocCreditCheckStatus = finDocCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @param totalCreditCheckStatus
     *            Overall Status of Credit Checks
     */
    public void setTotalCreditCheckStatus( @Nullable final String totalCreditCheckStatus )
    {
        rememberChangedField("TotalCreditCheckStatus", this.totalCreditCheckStatus);
        this.totalCreditCheckStatus = totalCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditCheckStatus</b>
     * </p>
     *
     * @param centralCreditCheckStatus
     *            Status of Credit Check SAP Credit Management
     */
    public void setCentralCreditCheckStatus( @Nullable final String centralCreditCheckStatus )
    {
        rememberChangedField("CentralCreditCheckStatus", this.centralCreditCheckStatus);
        this.centralCreditCheckStatus = centralCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CentralCreditChkTechErrSts</b>
     * </p>
     *
     * @param centralCreditChkTechErrSts
     *            Status of Technical Error SAP Credit Management
     */
    public void setCentralCreditChkTechErrSts( @Nullable final String centralCreditChkTechErrSts )
    {
        rememberChangedField("CentralCreditChkTechErrSts", this.centralCreditChkTechErrSts);
        this.centralCreditChkTechErrSts = centralCreditChkTechErrSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CreditBlockedSalesDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesDocument", getSalesDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesDocument", getSalesDocument());
        values.put("SDDocumentCategory", getSDDocumentCategory());
        values.put("SalesDocumentType", getSalesDocumentType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("SoldToParty", getSoldToParty());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CustomerCreditAccount", getCustomerCreditAccount());
        values.put("ControllingAreaCurrency", getControllingAreaCurrency());
        values.put("ReleasedCreditAmount", getReleasedCreditAmount());
        values.put("CreditBlockReleaseDate", getCreditBlockReleaseDate());
        values.put("NextShippingDate", getNextShippingDate());
        values.put("NextCreditCheckDate", getNextCreditCheckDate());
        values.put("FinDocCreditCheckStatus", getFinDocCreditCheckStatus());
        values.put("TotalCreditCheckStatus", getTotalCreditCheckStatus());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("CentralCreditCheckStatus", getCentralCreditCheckStatus());
        values.put("CentralCreditChkTechErrSts", getCentralCreditChkTechErrSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SDDocumentCategory") ) {
                final Object value = values.remove("SDDocumentCategory");
                if( (value == null) || (!value.equals(getSDDocumentCategory())) ) {
                    setSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentType") ) {
                final Object value = values.remove("SalesDocumentType");
                if( (value == null) || (!value.equals(getSalesDocumentType())) ) {
                    setSalesDocumentType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("CustomerCreditAccount") ) {
                final Object value = values.remove("CustomerCreditAccount");
                if( (value == null) || (!value.equals(getCustomerCreditAccount())) ) {
                    setCustomerCreditAccount(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaCurrency") ) {
                final Object value = values.remove("ControllingAreaCurrency");
                if( (value == null) || (!value.equals(getControllingAreaCurrency())) ) {
                    setControllingAreaCurrency(((String) value));
                }
            }
            if( values.containsKey("ReleasedCreditAmount") ) {
                final Object value = values.remove("ReleasedCreditAmount");
                if( (value == null) || (!value.equals(getReleasedCreditAmount())) ) {
                    setReleasedCreditAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditBlockReleaseDate") ) {
                final Object value = values.remove("CreditBlockReleaseDate");
                if( (value == null) || (!value.equals(getCreditBlockReleaseDate())) ) {
                    setCreditBlockReleaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NextShippingDate") ) {
                final Object value = values.remove("NextShippingDate");
                if( (value == null) || (!value.equals(getNextShippingDate())) ) {
                    setNextShippingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("NextCreditCheckDate") ) {
                final Object value = values.remove("NextCreditCheckDate");
                if( (value == null) || (!value.equals(getNextCreditCheckDate())) ) {
                    setNextCreditCheckDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FinDocCreditCheckStatus") ) {
                final Object value = values.remove("FinDocCreditCheckStatus");
                if( (value == null) || (!value.equals(getFinDocCreditCheckStatus())) ) {
                    setFinDocCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("TotalCreditCheckStatus") ) {
                final Object value = values.remove("TotalCreditCheckStatus");
                if( (value == null) || (!value.equals(getTotalCreditCheckStatus())) ) {
                    setTotalCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("CentralCreditCheckStatus") ) {
                final Object value = values.remove("CentralCreditCheckStatus");
                if( (value == null) || (!value.equals(getCentralCreditCheckStatus())) ) {
                    setCentralCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("CentralCreditChkTechErrSts") ) {
                final Object value = values.remove("CentralCreditChkTechErrSts");
                if( (value == null) || (!value.equals(getCentralCreditChkTechErrSts())) ) {
                    setCentralCreditChkTechErrSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CreditBlockedSalesDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CreditBlockedSalesDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditBlockedSalesDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditBlockedSalesDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH);
    }

}
