/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.selectable.SalesDocumentRjcnReasonSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
 * SalesDocumentRjcnReason} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SalesDocumentRjcnReasonByKeyFluentHelper
    extends
    FluentHelperByKey<SalesDocumentRjcnReasonByKeyFluentHelper, SalesDocumentRjcnReason, SalesDocumentRjcnReasonSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
     * SalesDocumentRjcnReason} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesDocumentRjcnReason}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesDocumentRjcnReason}
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public SalesDocumentRjcnReasonByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesDocumentRjcnReason )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesDocumentRjcnReason", salesDocumentRjcnReason);
    }

    @Override
    @Nonnull
    protected Class<SalesDocumentRjcnReason> getEntityClass()
    {
        return SalesDocumentRjcnReason.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
