/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesDocumentWithCreditBlocksServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService
 * SalesDocumentWithCreditBlocksService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultSalesDocumentWithCreditBlocksServiceBatch
    extends
    BatchFluentHelperBasic<SalesDocumentWithCreditBlocksServiceBatch, SalesDocumentWithCreditBlocksServiceBatchChangeSet>
    implements
    SalesDocumentWithCreditBlocksServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesDocumentWithCreditBlocksServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesDocumentWithCreditBlocksServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesDocumentWithCreditBlocksServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesDocumentWithCreditBlocksServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesDocumentWithCreditBlocksServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesDocumentWithCreditBlocksServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesDocumentWithCreditBlocksServiceBatchChangeSet(this, service);
    }

}
