/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SalesDocumentWithCreditBlocksServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService
 * SalesDocumentWithCreditBlocksService}.
 *
 */
public class DefaultSalesDocumentWithCreditBlocksServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesDocumentWithCreditBlocksServiceBatch, SalesDocumentWithCreditBlocksServiceBatchChangeSet>
    implements
    SalesDocumentWithCreditBlocksServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesDocumentWithCreditBlocksServiceBatchChangeSet(
        @Nonnull final DefaultSalesDocumentWithCreditBlocksServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesDocumentWithCreditBlocksService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesDocumentWithCreditBlocksServiceBatchChangeSet getThis()
    {
        return this;
    }

}
