/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument
 * CreditBlockedSalesDocument}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.field.CreditBlockedSalesDocumentField
 * CreditBlockedSalesDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.link.CreditBlockedSalesDocumentLink
 * CreditBlockedSalesDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SD_DOCUMENT_CATEGORY
 * SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SALES_DOCUMENT_TYPE
 * SALES_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#TOTAL_NET_AMOUNT
 * TOTAL_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CUSTOMER_CREDIT_ACCOUNT
 * CUSTOMER_CREDIT_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CONTROLLING_AREA_CURRENCY
 * CONTROLLING_AREA_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#RELEASED_CREDIT_AMOUNT
 * RELEASED_CREDIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CREDIT_BLOCK_RELEASE_DATE
 * CREDIT_BLOCK_RELEASE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#NEXT_SHIPPING_DATE
 * NEXT_SHIPPING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#NEXT_CREDIT_CHECK_DATE
 * NEXT_CREDIT_CHECK_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#FIN_DOC_CREDIT_CHECK_STATUS
 * FIN_DOC_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#OVERALL_SD_PROCESS_STATUS
 * OVERALL_SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CENTRAL_CREDIT_CHECK_STATUS
 * CENTRAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument#CENTRAL_CREDIT_CHK_TECH_ERR_STS
 * CENTRAL_CREDIT_CHK_TECH_ERR_STS}</li>
 * </ul>
 *
 */
public interface CreditBlockedSalesDocumentSelectable extends EntitySelectable<CreditBlockedSalesDocument>
{

}
