/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
 * SalesDocumentRjcnReason}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.field.SalesDocumentRjcnReasonField
 * SalesDocumentRjcnReasonField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.link.SalesDocumentRjcnReasonLink
 * SalesDocumentRjcnReasonLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason#SALES_DOCUMENT_RJCN_REASON_TEXT
 * SALES_DOCUMENT_RJCN_REASON_TEXT}</li>
 * </ul>
 *
 */
public interface SalesDocumentRjcnReasonSelectable extends EntitySelectable<SalesDocumentRjcnReason>
{

}
