/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.field.SalesInquiryItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.selectable.SalesInquiryItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Inquiry Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesInquiryItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesInquiryItem extends VdmEntity<SalesInquiryItem>
{

    /**
     * Selector for all available fields of SalesInquiryItem.
     *
     */
    public final static SalesInquiryItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiry</b>
     * </p>
     *
     * @return Sales Inquiry
     */
    @Key
    @SerializedName( "SalesInquiry" )
    @JsonProperty( "SalesInquiry" )
    @Nullable
    @ODataField( odataName = "SalesInquiry" )
    private String salesInquiry;
    /**
     * Use with available fluent helpers to apply the <b>SalesInquiry</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> SALES_INQUIRY = new SalesInquiryItemField<String>("SalesInquiry");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItem</b>
     * </p>
     *
     * @return Sales Inquiry Item
     */
    @Key
    @SerializedName( "SalesInquiryItem" )
    @JsonProperty( "SalesInquiryItem" )
    @Nullable
    @ODataField( odataName = "SalesInquiryItem" )
    private String salesInquiryItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesInquiryItem</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> SALES_INQUIRY_ITEM =
        new SalesInquiryItemField<String>("SalesInquiryItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> HIGHER_LEVEL_ITEM =
        new SalesInquiryItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SalesInquiryItemCategory" )
    @JsonProperty( "SalesInquiryItemCategory" )
    @Nullable
    @ODataField( odataName = "SalesInquiryItemCategory" )
    private String salesInquiryItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesInquiryItemCategory</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> SALES_INQUIRY_ITEM_CATEGORY =
        new SalesInquiryItemField<String>("SalesInquiryItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "SalesInquiryItemText" )
    @JsonProperty( "SalesInquiryItemText" )
    @Nullable
    @ODataField( odataName = "SalesInquiryItemText" )
    private String salesInquiryItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesInquiryItemText</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> SALES_INQUIRY_ITEM_TEXT =
        new SalesInquiryItemField<String>("SalesInquiryItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesInquiryItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> MATERIAL = new SalesInquiryItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> MATERIAL_BY_CUSTOMER =
        new SalesInquiryItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<BigDecimal> REQUESTED_QUANTITY =
        new SalesInquiryItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> REQUESTED_QUANTITY_UNIT =
        new SalesInquiryItemField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemOrderProbabilityInPercent</b>
     * </p>
     *
     * @return Order Probability of the Item
     */
    @SerializedName( "ItemOrderProbabilityInPercent" )
    @JsonProperty( "ItemOrderProbabilityInPercent" )
    @Nullable
    @ODataField( odataName = "ItemOrderProbabilityInPercent" )
    private String itemOrderProbabilityInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ItemOrderProbabilityInPercent</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> ITEM_ORDER_PROBABILITY_IN_PERCENT =
        new SalesInquiryItemField<String>("ItemOrderProbabilityInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeToItem</b>
     * </p>
     *
     * @return Item for Which this Item is an Alternative
     */
    @SerializedName( "AlternativeToItem" )
    @JsonProperty( "AlternativeToItem" )
    @Nullable
    @ODataField( odataName = "AlternativeToItem" )
    private String alternativeToItem;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeToItem</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> ALTERNATIVE_TO_ITEM =
        new SalesInquiryItemField<String>("AlternativeToItem");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new SalesInquiryItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<BigDecimal> ITEM_NET_WEIGHT =
        new SalesInquiryItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> ITEM_WEIGHT_UNIT =
        new SalesInquiryItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<BigDecimal> ITEM_VOLUME =
        new SalesInquiryItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> ITEM_VOLUME_UNIT =
        new SalesInquiryItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> TRANSACTION_CURRENCY =
        new SalesInquiryItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<BigDecimal> NET_AMOUNT =
        new SalesInquiryItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> MATERIAL_GROUP =
        new SalesInquiryItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> BATCH = new SalesInquiryItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> INCOTERMS_CLASSIFICATION =
        new SalesInquiryItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesInquiryItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> INCOTERMS_LOCATION1 =
        new SalesInquiryItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> INCOTERMS_LOCATION2 =
        new SalesInquiryItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesInquiryItemField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new SalesInquiryItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> WBS_ELEMENT = new SalesInquiryItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesInquiryItemField<String> SD_PROCESS_STATUS =
        new SalesInquiryItemField<String>("SDProcessStatus");
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesInquiryItem</b> to multiple <b>SalesInquiryItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesInquiryItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SalesInquiryItem</b> to multiple
     * <b>SalesInquiryItemPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesInquiryItemPrcgElmnt> toPricingElement;
    /**
     * Navigation property <b>to_SalesInquiry</b> for <b>SalesInquiryItem</b> to single <b>SalesInquiry</b>.
     *
     */
    @SerializedName( "to_SalesInquiry" )
    @JsonProperty( "to_SalesInquiry" )
    @ODataField( odataName = "to_SalesInquiry" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesInquiry toSalesInquiry;
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesInquiryItemLink<SalesInquiryItemPartner> TO_PARTNER =
        new SalesInquiryItemLink<SalesInquiryItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SalesInquiryItemLink<SalesInquiryItemPrcgElmnt> TO_PRICING_ELEMENT =
        new SalesInquiryItemLink<SalesInquiryItemPrcgElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesInquiry</b> navigation property to query operations.
     *
     */
    public final static SalesInquiryItemOneToOneLink<SalesInquiry> TO_SALES_INQUIRY =
        new SalesInquiryItemOneToOneLink<SalesInquiry>("to_SalesInquiry");

    @Nonnull
    @Override
    public Class<SalesInquiryItem> getType()
    {
        return SalesInquiryItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiry</b>
     * </p>
     *
     * @param salesInquiry
     *            Sales Inquiry
     */
    public void setSalesInquiry( @Nullable final String salesInquiry )
    {
        rememberChangedField("SalesInquiry", this.salesInquiry);
        this.salesInquiry = salesInquiry;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItem</b>
     * </p>
     *
     * @param salesInquiryItem
     *            Sales Inquiry Item
     */
    public void setSalesInquiryItem( @Nullable final String salesInquiryItem )
    {
        rememberChangedField("SalesInquiryItem", this.salesInquiryItem);
        this.salesInquiryItem = salesInquiryItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItemCategory</b>
     * </p>
     *
     * @param salesInquiryItemCategory
     *            Sales Document Item Category
     */
    public void setSalesInquiryItemCategory( @Nullable final String salesInquiryItemCategory )
    {
        rememberChangedField("SalesInquiryItemCategory", this.salesInquiryItemCategory);
        this.salesInquiryItemCategory = salesInquiryItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItemText</b>
     * </p>
     *
     * @param salesInquiryItemText
     *            Short Text for Sales Order Item
     */
    public void setSalesInquiryItemText( @Nullable final String salesInquiryItemText )
    {
        rememberChangedField("SalesInquiryItemText", this.salesInquiryItemText);
        this.salesInquiryItemText = salesInquiryItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemOrderProbabilityInPercent</b>
     * </p>
     *
     * @param itemOrderProbabilityInPercent
     *            Order Probability of the Item
     */
    public void setItemOrderProbabilityInPercent( @Nullable final String itemOrderProbabilityInPercent )
    {
        rememberChangedField("ItemOrderProbabilityInPercent", this.itemOrderProbabilityInPercent);
        this.itemOrderProbabilityInPercent = itemOrderProbabilityInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeToItem</b>
     * </p>
     *
     * @param alternativeToItem
     *            Item for Which this Item is an Alternative
     */
    public void setAlternativeToItem( @Nullable final String alternativeToItem )
    {
        rememberChangedField("AlternativeToItem", this.alternativeToItem);
        this.alternativeToItem = alternativeToItem;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesInquiryItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesInquiry", getSalesInquiry());
        result.put("SalesInquiryItem", getSalesInquiryItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesInquiry", getSalesInquiry());
        values.put("SalesInquiryItem", getSalesInquiryItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("SalesInquiryItemCategory", getSalesInquiryItemCategory());
        values.put("SalesInquiryItemText", getSalesInquiryItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("ItemOrderProbabilityInPercent", getItemOrderProbabilityInPercent());
        values.put("AlternativeToItem", getAlternativeToItem());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Batch", getBatch());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("WBSElement", getWBSElement());
        values.put("SDProcessStatus", getSDProcessStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesInquiry") ) {
                final Object value = values.remove("SalesInquiry");
                if( (value == null) || (!value.equals(getSalesInquiry())) ) {
                    setSalesInquiry(((String) value));
                }
            }
            if( values.containsKey("SalesInquiryItem") ) {
                final Object value = values.remove("SalesInquiryItem");
                if( (value == null) || (!value.equals(getSalesInquiryItem())) ) {
                    setSalesInquiryItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("SalesInquiryItemCategory") ) {
                final Object value = values.remove("SalesInquiryItemCategory");
                if( (value == null) || (!value.equals(getSalesInquiryItemCategory())) ) {
                    setSalesInquiryItemCategory(((String) value));
                }
            }
            if( values.containsKey("SalesInquiryItemText") ) {
                final Object value = values.remove("SalesInquiryItemText");
                if( (value == null) || (!value.equals(getSalesInquiryItemText())) ) {
                    setSalesInquiryItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ItemOrderProbabilityInPercent") ) {
                final Object value = values.remove("ItemOrderProbabilityInPercent");
                if( (value == null) || (!value.equals(getItemOrderProbabilityInPercent())) ) {
                    setItemOrderProbabilityInPercent(((String) value));
                }
            }
            if( values.containsKey("AlternativeToItem") ) {
                final Object value = values.remove("AlternativeToItem");
                if( (value == null) || (!value.equals(getAlternativeToItem())) ) {
                    setAlternativeToItem(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesInquiryItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SalesInquiryItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesInquiryItemPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SalesInquiryItemPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesInquiry") ) {
                final Object value = (values).remove("to_SalesInquiry");
                if( value instanceof Map ) {
                    if( toSalesInquiry == null ) {
                        toSalesInquiry = new SalesInquiry();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesInquiry.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesInquiryItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesInquiryItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesInquiryItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesInquiryItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toSalesInquiry != null ) {
            (values).put("to_SalesInquiry", toSalesInquiry);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesInquiryItemPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesInquiryItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesInquiryItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SalesInquiryItemPartner.class);
    }

    /**
     * Retrieval of associated <b>SalesInquiryItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesInquiryItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesInquiryItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesInquiryItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesInquiryItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesInquiryItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesInquiryItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SalesInquiryItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesInquiryItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SalesInquiryItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesInquiryItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesInquiryItemPartner</b> entities.
     */
    public void addPartner( SalesInquiryItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesInquiryItemPrcgElmnt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesInquiryItemPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesInquiryItemPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SalesInquiryItemPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>SalesInquiryItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesInquiryItemPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesInquiryItemPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SalesInquiryItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SalesInquiryItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SalesInquiryItemPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesInquiryItemPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SalesInquiryItemPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesInquiryItemPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SalesInquiryItemPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesInquiryItemPrcgElmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesInquiryItemPrcgElmnt</b> entities.
     */
    public void addPricingElement( SalesInquiryItemPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesInquiry</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesInquiry</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesInquiry</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesInquiry fetchSalesInquiry()
    {
        return fetchFieldAsSingle("to_SalesInquiry", SalesInquiry.class);
    }

    /**
     * Retrieval of associated <b>SalesInquiry</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesInquiry</b>.
     * <p>
     * If the navigation property <b>to_SalesInquiry</b> of a queried <b>SalesInquiryItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesInquiry</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesInquiry getSalesInquiryOrFetch()
    {
        if( toSalesInquiry == null ) {
            toSalesInquiry = fetchSalesInquiry();
        }
        return toSalesInquiry;
    }

    /**
     * Retrieval of associated <b>SalesInquiry</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesInquiry</b>.
     * <p>
     * If the navigation property for an entity <b>SalesInquiryItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesInquiry</b> is already loaded, the result will
     *         contain the <b>SalesInquiry</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesInquiry> getSalesInquiryIfPresent()
    {
        return Option.of(toSalesInquiry);
    }

    /**
     * Overwrites the associated <b>SalesInquiry</b> entity for the loaded navigation property <b>to_SalesInquiry</b>.
     *
     * @param value
     *            New <b>SalesInquiry</b> entity.
     */
    public void setSalesInquiry( final SalesInquiry value )
    {
        toSalesInquiry = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesInquiryItem instances.
     *
     */
    public final static class SalesInquiryItemBuilder
    {

        private List<SalesInquiryItemPartner> toPartner = Lists.newArrayList();
        private List<SalesInquiryItemPrcgElmnt> toPricingElement = Lists.newArrayList();
        private SalesInquiry toSalesInquiry;
        private String salesInquiry = null;

        private SalesInquiryItem.SalesInquiryItemBuilder toPartner( final List<SalesInquiryItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesInquiryItem</b> to multiple <b>SalesInquiryItemPartner</b>.
         *
         * @param value
         *            The SalesInquiryItemPartners to build this SalesInquiryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItem.SalesInquiryItemBuilder partner( SalesInquiryItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesInquiryItem.SalesInquiryItemBuilder toPricingElement( final List<SalesInquiryItemPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SalesInquiryItem</b> to multiple
         * <b>SalesInquiryItemPrcgElmnt</b>.
         *
         * @param value
         *            The SalesInquiryItemPrcgElmnts to build this SalesInquiryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItem.SalesInquiryItemBuilder pricingElement( SalesInquiryItemPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private SalesInquiryItem.SalesInquiryItemBuilder toSalesInquiry( final SalesInquiry value )
        {
            toSalesInquiry = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesInquiry</b> for <b>SalesInquiryItem</b> to single <b>SalesInquiry</b>.
         *
         * @param value
         *            The SalesInquiry to build this SalesInquiryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItem.SalesInquiryItemBuilder salesInquiry( final SalesInquiry value )
        {
            return toSalesInquiry(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesInquiry</b>
         * </p>
         *
         * @param value
         *            The salesInquiry to build this SalesInquiryItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItem.SalesInquiryItemBuilder salesInquiry( final String value )
        {
            salesInquiry = value;
            return this;
        }

    }

}
